/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.fileWatcher;

import com.freebooth.fileWatcher.FileWatcher;
import com.freebooth.fileWatcher.ThumbDecorator;
import com.freebooth.fileWatcher.WatermarkDecorator;
import com.freebooth.utilities.BILoader;
import com.freebooth.utilities.FileExistenceChecker;
import com.freebooth.utilities.PathCreator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SlideshowFileWatcher
extends FileWatcher {
    private List<String> images = new ArrayList<String>();

    public SlideshowFileWatcher() {
        super(new PathCreator().getImagePath());
        this.decorator = new WatermarkDecorator(new ThumbDecorator(true));
        this.decorateStoredImages();
    }

    @Override
    public void processReadImage(File image) {
        this.images.add(image.getName());
    }

    @Override
    public void processDeletion(File image) {
    }

    public String getLastImage() {
        if (!this.images.isEmpty()) {
            return this.images.get(this.images.size() - 1);
        }
        return new String("");
    }

    public List<String> getAllImages() {
        return this.images;
    }

    @Override
    protected void decorateStoredImages() {
        File[] listOfFiles;
        File folder = new File(new PathCreator().getImagePath());
        for (File file : listOfFiles = folder.listFiles()) {
            File decoratedFile;
            boolean allFilesExist;
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            String fileEnding = fileName.substring(fileName.lastIndexOf("."));
            boolean bl = allFilesExist = FileExistenceChecker.webThumbExists(fileName) && FileExistenceChecker.watermarkExists(fileName);
            if (!file.isFile() || !fileEnding.equals(".jpg") && !fileEnding.equals(".JPG")) continue;
            if (allFilesExist) {
                decoratedFile = this.decorator.processImage(file, null);
            } else {
                BufferedImage image = BILoader.loadImage(new PathCreator().getImagePath() + File.separator + file.getName());
                decoratedFile = this.decorator.processImage(file, image);
            }
            this.images.add(decoratedFile.getName());
        }
    }
}

