/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.fileWatcher;

import com.freebooth.fileWatcher.ImageDecorator;
import com.freebooth.utilities.PathCreator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.regex.Pattern;

public abstract class FileWatcher
implements Runnable {
    String lastImage = new String();
    boolean run = true;
    ImageDecorator decorator = null;
    String pathToWatch;

    public FileWatcher(String pathToWatch) {
        this.pathToWatch = pathToWatch;
    }

    public void stopFileWatcher() {
        this.run = false;
    }

    public abstract void processReadImage(File var1);

    public abstract void processDeletion(File var1);

    @Override
    public void run() {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(this.pathToWatch, new String[0]);
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            System.out.println("Watch Service registered for dir: " + dir.toString());
            while (this.run) {
                WatchKey key;
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ex) {
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path fileName = (Path)ev.context();
                    if (!fileName.toString().contains(".")) continue;
                    System.out.println("new file tralala: " + kind + "-" + fileName);
                    String fileEnding = fileName.toString().substring(fileName.toString().lastIndexOf("."));
                    String overlay = fileName.toString().split(Pattern.quote("."))[0];
                    if (!fileEnding.equals(".jpg") && !fileEnding.equals(".JPG") || this.lastImage.equals(fileName.toString()) || overlay.equals("overlay")) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.processDeletion(new File(new PathCreator().getImagePath() + fileName));
                        continue;
                    }
                    File newImage = new File(new PathCreator().getImagePath() + fileName);
                    if (this.decorator != null) {
                        newImage = this.decorator.processImage(newImage, null);
                    }
                    this.lastImage = fileName.toString();
                    this.processReadImage(newImage);
                }
                boolean valid = key.reset();
                if (valid) continue;
                break;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    protected abstract void decorateStoredImages();
}

