<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => '":timezone" içinde saklanır',
    'displayed_in_tz'                           => '":timezone" içinde görüntülenir',
    'close'                                     => 'Kapat',
    'actions'                                   => 'Eylemler',
    'edit'                                      => 'Düzenle',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'İşlem günlüğü kimliği',
    'delete'                                    => 'Sil',
    'split'                                     => 'Böl',
    'single_split'                              => 'Böl',
    'clone'                                     => 'Klonla',
    'clone_and_edit'                            => 'Klonla ve düzenle',
    'confirm_action'                            => 'İşlemi onayla',
    'last_seven_days'                           => 'Son yedi gün',
    'last_thirty_days'                          => 'Son otuz gün',
    'last_180_days'                             => 'Son 180 gün',
    'month_to_date'                             => 'Aydan bugüne',
    'year_to_date'                              => 'Yıldan bugüne',
    'YTD'                                       => 'Son 2 Ay',
    'welcome_back'                              => 'Neler oluyor?',
    'main_dashboard_page_title'                 => 'Ana Sayfa',
    'everything'                                => 'Her şey',
    'today'                                     => 'bugün',
    'customRange'                               => 'Özel menzil',
    'date_range'                                => 'Tarih Aralığı',
    'apply'                                     => 'Uygula',
    'select_date'                               => 'Tarih Seç..',
    'cancel'                                    => 'İptal',
    'from'                                      => 'Gönderen',
    'to'                                        => 'Alıcı',
    'structure'                                 => 'Yapı',
    'help_translating'                          => 'Bu yardım metni henüz sizin dilinizde bulunmamaktadır. <a href="https://crowdin.com/project/firefly-iii-help">Çeviriye katkı sağlamak ister misiniz?</a>',
    'showEverything'                            => 'Her şeyi göster',
    'never'                                     => 'Asla',
    'no_results_for_empty_search'               => 'Aramanız boştu, bu nedenle hiçbir şey bulunamadı.',
    'removed_amount'                            => '" :amount" kaldırıldı',
    'added_amount'                              => ':amount eklendi',
    'asset_account_role_help'                   => 'Seçiminizden kaynaklanan ekstra seçenekler daha sonra ayarlanabilir.',
    'Opening balance'                           => 'Açılış bakiyesi',
    'create_new_stuff'                          => 'Yeni bir şey oluştur',
    'new_withdrawal'                            => 'Yeni para çekme',
    'create_new_transaction'                    => 'Yeni Transfer Oluştur',
    'sidebar_frontpage_create'                  => 'Yeni',
    'new_transaction'                           => 'Yeni işlem',
    'no_rules_for_bill'                         => 'Bu abonelikle ilişkili hiçbir kural yoktur.',
    'go_to_asset_accounts'                      => 'Varlık hesaplarınızı görüntüleyin
',
    'go_to_budgets'                             => 'Bütçelerine git',
    'go_to_withdrawals'                         => 'Para çekme işlemlerine gidin',
    'clones_journal_x'                          => 'Bu işlem ":description" (#:id) kopyasıdır',
    'go_to_categories'                          => 'Kategorilerinize gidin',
    'go_to_bills'                               => 'Aboneliklerinize gidin',
    'go_to_expense_accounts'                    => 'Gider hesaplarınızı görün',
    'go_to_revenue_accounts'                    => 'Gelir hesaplarınızı görün',
    'go_to_piggies'                             => 'Kumbaranıza gidin',
    'new_deposit'                               => 'Yeni Depozito',
    'new_transfer'                              => 'Yeni transfer',
    'new_transfers'                             => 'Yeni transfer',
    'new_asset_account'                         => 'Yeni varlık hesabı',
    'new_expense_account'                       => 'Yeni gider hesabı',
    'new_revenue_account'                       => 'Yeni Gelir Hesabı',
    'new_liabilities_account'                   => 'Yeni sorumluluk',
    'new_budget'                                => 'Yeni bütçe',
    'new_bill'                                  => 'Yeni Abonelik',
    'block_account_logout'                      => 'Çıkış yaptınız. Engellenen hesaplar bu siteyi kullanamaz. Geçerli bir e-posta adresiyle kayıt oldunuz mu?',
    'flash_success'                             => 'Başarılı!',
    'flash_info'                                => 'İleti',
    'flash_warning'                             => 'Uyarı!',
    'flash_error'                               => 'Hata!',
    'flash_danger'                              => 'Tehlike!',
    'flash_info_multiple'                       => 'Bir ileti var|:count ileti var',
    'flash_error_multiple'                      => 'Bir hata var|:count hata var',
    'net_worth'                                 => 'Net değer',
    'help_for_this_page'                        => 'Bu sayfa için yardım',
    'help_for_this_page_body'                   => 'Bu sayfa hakkında daha fazla bilgi bulabilirsiniz <a href="https://docs.firefly-iii.org/">belgelerde</a>.',
    'two_factor_welcome'                        => 'Merhaba!',
    'two_factor_enter_code'                     => 'Devam etmek için lütfen iki faktörlü kimlik doğrulama kodunuzu girin. Uygulamanız sizin için oluşturabilir.',
    'two_factor_code_here'                      => 'Kodu buraya girin',
    'two_factor_title'                          => 'İki faktörlü kimlik doğrulaması',
    'authenticate'                              => 'Kimliği doğrula',
    'two_factor_forgot_title'                   => 'Kayıp iki faktörlü kimlik doğrulaması',
    'two_factor_forgot'                         => 'İki faktörlü kimlik doğrulama cihazını unuttum.',
    'two_factor_lost_header'                    => 'İki faktörlü kimlik doğrulamanızı mı kaybettiniz?',
    'two_factor_lost_intro'                     => 'Eğer yedek kodlarınızı da kayıp ettiyseniz, şansınız kötü. Bu web arayüzünden düzeltebileceğiniz bir şey değil. İki seçeneğiniz var.',
    'two_factor_lost_fix_self'                  => 'Kendi Firefly III örneğinizi çalıştırıyorsanız, talimatlar için <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working"> SSS</a> bölümündeki bu girişi okuyun.',
    'two_factor_lost_fix_owner'                 => 'Aksi takdirde, site sahibine (<a href="mailto::site_owner">:site_owner</a>) e-posta gönderin ve iki faktörlü kimlik doğrulamasını sıfırlamasını isteyin.',
    'mfa_backup_code'                           => 'Firefly III giriş yapmak için yedek kullandınız. Bu kod tekrar kullanılamaz, o yüzden listenizden çıkartın.',
    'pref_two_factor_new_backup_codes'          => 'Yeni yedek kodları alın',
    'pref_two_factor_backup_code_count'         => 'Geçerli :count yedek kodunuz var.|Sizin :count geçerli yedek kodunuz var.',
    '2fa_i_have_them'                           => 'Hepsini sakladım!',
    'warning_much_data'                         => ':days günlük verinin yüklenmesi biraz zaman alabilir.',
    'registered'                                => 'Başarıyla kaydoldunuz!',
    'Default asset account'                     => 'Varsayılan varlık hesabı',
    'no_budget_pointer'                         => 'Henüz bütçeniz yok gibi görünüyor. <a href="budgets">bütçeler</a> sayfasında biraz oluşturmalısınız. Bütçeler, giderleri takip etmenize yardımcı olabilir.',
    'no_bill_pointer'                           => 'Henüz aboneliğiniz yok gibi görünüyor. <a href="subscriptions">Abonelik</a> sayfasında bir abonelik oluşturmalısınız. Abonelikler, harcamalarınızı takip etmenize yardımcı olabilir.',
    'Savings account'                           => 'Birikim Hesabı',
    'Credit card'                               => 'Kredi Kartı',
    'source_accounts'                           => 'Kaynak hesap|Kaynak hesaplar',
    'destination_accounts'                      => 'Hedef hesap|Hedef hesaplar',
    'user_id_is'                                => 'Kullanıcı kimliğiniz <strong>:user</strong>',
    'field_supports_markdown'                   => 'Bu alan <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown\'u destekliyor</a>.',
    'need_more_help'                            => 'Firefly III kullanımında daha fazla yardıma ihtiyacınız olursa, lütfen <a href="https://github.com/firefly-iii/firefly-iii/issues">Github\'da bir talep açın</a>.',
    'reenable_intro_text'                       => 'Ayni zamanda <a href="#" id="reenableGuidance">giriş rehberi</a> yeniden aktive edebilirsin.',
    'intro_boxes_after_refresh'                 => 'Sayfayı yenilediğinizde tanıtım kutuları yeniden görünecektir.',
    'show_all_no_filter'                        => 'Tüm işlemleri, tarihe göre gruplamadan gösterin.',
    'expenses_by_category'                      => 'Kategoriye göre giderler',
    'expenses_by_budget'                        => 'Bütçeye göre giderler',
    'income_by_category'                        => 'Kategoriye göre gelir',
    'expenses_by_asset_account'                 => 'Varlık hesabına göre giderler',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III sizi doğru sayfaya yönlendiremiyor. Özür dileriz.',
    'sum_of_expenses'                           => 'Giderlerin Toplamı',
    'sum_of_income'                             => 'Gelirin Toplamı',
    'liabilities'                               => 'Yükümlülükler',
    'spent_in_specific_budget'                  => 'Miktar ":budget" harcandı',
    'spent_in_specific_double'                  => '":account" hesabında harcandı',
    'earned_in_specific_double'                 => '":account" tarafından kazanıldı',
    'source_account'                            => 'Kaynak hesap',
    'source_account_reconciliation'             => 'Bir mutabakat işleminin kaynak hesabını düzenleyemezsiniz.',
    'destination_account'                       => 'Hedef hesap',
    'destination_account_reconciliation'        => 'Bir mutabakat işleminin hedef hesabını düzenleyemezsiniz.',
    'sum_of_expenses_in_budget'                 => 'Harcanan toplam bütçe ":budget"',
    'left_in_budget_limit'                      => 'Bütçeye göre harcama ayrıldı',
    'current_period'                            => 'Cari dönem',
    'show_the_current_period_and_overview'      => 'Geçerli periyodu ve genel bakışı göster',
    'pref_languages_locale'                     => 'İngilizce dışındaki bir dilin düzgün çalışması için, işletim sisteminizin doğru yerel ayar bilgileri ile donatılmış olmalıdır. Aksi halde, tarih, para birim verileri ve tutarı yanlış gösterilebilir.',
    'budget_in_period'                          => '":name" bütçesi için :start ve :end aralığında yapılan :currency işlemleri',
    'chart_budget_in_period'                    => '":name" bütçesi için :start ve :end aralığında yapılan :currency işlemlerin grafiği',
    'chart_budget_in_period_only_currency'      => 'Bütçe miktarı :currency dövizinde, dolayısı ile bu grafik sadece :currency dövizinde yapılan işlemleri gösterir.',
    'chart_account_in_period'                   => '":name" (:balance) hesabı için :start ve :end arasındaki tüm işlemler için grafik',
    'chart_category_in_period'                  => ':start ve :end arasında ":name" kategorisindeki bütün işlemler için grafik',
    'chart_category_all'                        => '":name" kategorisinde bütün işlemler çizelgesi',
    'clone_withdrawal'                          => 'Bu para çekimini klonla',
    'clone_deposit'                             => 'Bu depozitoyu klonla',
    'clone_transfer'                            => 'Bu transferi kopyala',
    'multi_select_no_selection'                 => 'Hiçbiri seçilmedi',
    'multi_select_select_all'                   => 'Tümünü seç',
    'multi_select_n_selected'                   => 'seçili',
    'multi_select_all_selected'                 => 'Tümü seçildi',
    'multi_select_filter_placeholder'           => 'Bul..',
    'intro_next_label'                          => 'Sonraki',
    'intro_prev_label'                          => 'Önceki',
    'intro_skip_label'                          => 'Atla',
    'intro_done_label'                          => 'Bitti',
    'between_dates_breadcrumb'                  => ':start ve :end arasında',
    'all_journals_without_budget'               => 'Bütçesiz tüm işlemler',
    'journals_without_budget'                   => 'Bütçesiz İşlemler',
    'all_journals_without_category'             => 'Kategorisiz tüm işlemler',
    'journals_without_category'                 => 'Kategorisiz işlemler',
    'all_journals_for_account'                  => ':name hesabındaki tüm işlemler',
    'chart_all_journals_for_account'            => ':name hesabındaki tüm işlemlerin grafiği',
    'journals_in_period_for_account'            => ':start ile :end tarihleri arasında :name hesabından yapılan tüm işlemler',
    'journals_in_period_for_account_js'         => '{title} hesabı için {start} ile {end} arasındaki tüm işlemler',
    'transferred'                               => 'Transfer yapıldı',
    'all_withdrawal'                            => 'Tüm giderler',
    'all_transactions'                          => 'Tüm işlemler',
    'title_withdrawal_between'                  => 'Başlangıç ve Bitiş arasındaki tüm harcamalar',
    'all_deposit'                               => 'Toplam varlık',
    'title_deposit_between'                     => 'Başlangıç ve Bitiş arasındaki tüm gelir',
    'all_transfers'                             => 'Tüm transferler',
    'title_transfers_between'                   => ':start ile :end tarihleri arasındaki tüm işlemler',
    'all_transfer'                              => 'Tüm transferler',
    'all_journals_for_tag'                      => '":tag" etiketiyle yapılan tüm işlemler',
    'title_transfer_between'                    => ':start ile :end tarihleri arasındaki tüm işlemler',
    'all_journals_for_category'                 => '":name" kategorisindeki tüm işlemler',
    'all_journals_for_budget'                   => '":name" bütçesindeki tüm işlemler',
    'chart_all_journals_for_budget'             => ':name bütçesindeki tüm işlemlerin grafiği',
    'journals_in_period_for_category'           => ':start ile :end tarihleri arasında :name kategorisinde yapılan tüm işlemler',
    'journals_in_period_for_tag'                => ':start ile :end tarihleri arasında :tag etiketiyle yapılan tüm işlemler',
    'not_available_demo_user'                   => 'Erişmeye çalıştığınız özellik, demo kullanıcıları tarafından kullanılamaz.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Kaynak varlık hesabı "@source_name" sadece @soruce_currency işlemlerini kabul eder. Hedef varlık hesabı "@dest_name" sadece @dest_currency işlemlerini kabul eder. Aktarılan tutarı her iki para biriminde de doğru olarak girmeniz gerekir.',
    'transaction_data'                          => 'İşlem Verileri',
    'invalid_server_configuration'              => 'Geçersiz sunucu yapılandırması',
    'invalid_locale_settings'                   => 'Firefly III, sunucunuzda gerekli paketler eksik olduğundan parasal tutarları biçimlendiremiyor. Bunun <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">nasıl yapılacağına dair talimatlar</a> var.',
    'quickswitch'                               => 'Hızlı anahtar',
    'sign_in_to_start'                          => 'Oturumu başlatmak için giriş yapın',
    'sign_in'                                   => 'Oturum aç',
    'register_new_account'                      => 'Yeni hesap kaydı',
    'forgot_my_password'                        => 'Şifremi unuttum',
    'problems_with_input'                       => 'Girişinizle ilgili bazı problemler var.',
    'reset_password'                            => 'Şifreni sıfırla',
    'button_reset_password'                     => 'Parolayı Sıfırla',
    'reset_button'                              => 'Sıfırla',
    'want_to_login'                             => 'Giriş yapmak istiyorum',
    'login_page_title'                          => 'Firefly III\'e giriş yapın',
    'register_page_title'                       => 'Firefly III\'e kayıt olun',
    'forgot_pw_page_title'                      => 'Firefly III için şifrenizi mi unuttunuz',
    'reset_pw_page_title'                       => 'Firefly III şifrenizi sıfırlayın',
    'cannot_reset_demo_user'                    => 'Demo kullanıcısının şifresini sıfırlayamazsınız.',
    'no_att_demo_user'                          => 'Demo kullanıcısı ekleri yükleyemez.',
    'button_register'                           => 'Kayıt ol',
    'authorization'                             => 'Yetkilendirme',
    'active_bills_only'                         => 'sadece aktif abonelik',
    'active_bills_only_total'                   => 'tüm aktif abonelikler',
    'active_exp_bills_only'                     => 'Yalnızca aktif ve beklenen abonelikler',
    'active_exp_bills_only_total'               => 'sadece tüm aktif beklenen abonelikler',
    'per_period_sum_1D'                         => 'Beklenen günlük maliyetler',
    'per_period_sum_1W'                         => 'Beklenen haftalık maliyetler',
    'per_period_sum_1M'                         => 'Beklenen aylık maliyetler',
    'per_period_sum_3M'                         => 'Beklenen üç aylık maliyetler',
    'per_period_sum_6M'                         => 'Beklenen yarı yıllık maliyetler',
    'per_period_sum_1Y'                         => 'Beklenen yıllık maliyetler',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'beklenen toplam',
    'reconciliation_account_name'               => ':name mutabakatı (:currency)',
    'saved'                                     => 'Kaydedildi',
    'advanced_options'                          => 'Gelişmiş Ayarlar',
    'advanced_options_explain'                  => 'Firefly III\'teki bazı sayfalarda bu düğmenin arkasına gizlenmiş gelişmiş seçenekler bulunur. Bu sayfanın burada süslü bir yanı yok, ama diğerlerine bir göz atın!',
    'here_be_dragons'                           => 'İşte ejderhalar',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Web kancaları',
    'webhooks_breadcrumb'                       => 'Webhook\'lar',
    'webhooks_menu_disabled'                    => 'devre dışı',
    'no_webhook_messages'                       => 'Webhook mesajı yok',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'İşlem oluşturma sonrası',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'İşlem güncelleme sonrası',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'İşlem silme sonrası',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'İşlem detayları',
    'webhook_response_ACCOUNTS'                 => 'Hesap detayları',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'İncele',
    'create_new_webhook'                        => 'Yeni webhook oluştur',
    'webhooks_create_breadcrumb'                => 'Yeni webhook oluştur',
    'webhook_trigger_form_help'                 => 'Webhook\'un hangi olayı tetikleyeceğini belirtin',
    'webhook_response_form_help'                => 'Webhook\'un URL\'ye ne göndermesi gerektiğini belirleyin.',
    'webhook_delivery_form_help'                => 'Webhook\'un verileri hangi formatta iletmesi gerek.',
    'webhook_active_form_help'                  => 'Webhook\'un etkin olması gerekir, aksi takdirde çağrılmaz.',
    'stored_new_webhook'                        => 'Yeni webhook ":title" depolandı',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'View message',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Logs',
    'response'                                  => 'Response',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v: version Yetkilendirme İsteği',
    'authorization_request_intro'               => '"<strong>:client</strong>" uygulaması, mali yönetiminize erişmek için izin istiyor. Bu kayıtlara erişmesi için <strong>:client</strong>\'e yetki vermek ister misiniz?',
    'authorization_request_site'                => 'Firefly III verilerinize erişebilecek olan <code>:url</code> adresine yönlendirileceksiniz.',
    'authorization_request_invalid'             => 'Bu erişim isteği geçersiz. Lütfen bu bağlantıyı bir daha asla takip etmeyin.',
    'scopes_will_be_able'                       => 'Bu uygulama şunları yapabilir:',
    'button_authorize'                          => 'İzin ver',
    'none_in_select_list'                       => '(Yok)',
    'no_piggy_bank'                             => '(kumbara bankası yok)',
    'name_in_currency'                          => ':name :currency',
    'paid_in_currency'                          => ':currency olarak ödenen',
    'unpaid_in_currency'                        => ':currency olarak ödenmeyen',
    'is_alpha_warning'                          => 'Bir ALPHA sürümü çalıştırıyorsunuz. Hatalara ve sorunlara karşı dikkatli olun.',
    'is_beta_warning'                           => 'Bir BETA sürümünü çalıştırıyorsunuz. Hatalara ve sorunlara karşı dikkatli olun.',
    'all_destination_accounts'                  => 'Hedef Hesap(lar)',
    'all_source_accounts'                       => 'Kaynak Hesap',
    'back_to_index'                             => 'Dizine geri dön',
    'cant_logout_guard'                         => 'Firefly III oturumunuzu kapatamaz.',
    'internal_reference'                        => 'Dahili referans',

    // check for updates:
    'update_check_title'                        => 'Güncellemeleri kontrol et',
    'admin_update_check_title'                  => 'Güncellemeleri otomatik olarak kontrol et',
    'admin_update_check_explain'                => 'Firefly III, güncellemeleri otomatik olarak kontrol edebilir. Bu ayarı etkinleştirdiğinizde, Firefly III\'ün yeni bir sürümünün mevcut olup olmadığını görmek için Firefly III güncelleme sunucusuyla iletişime geçecektir. Olduğunda, bir bildirim alacaksınız. Bu bildirimi sağdaki düğmeyi kullanarak test edebilirsiniz. Firefly III\'ün güncellemeleri kontrol etmesini istiyorsanız lütfen aşağıda belirtin.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Daha sonra sor',
    'updates_do_not_check'                      => 'Güncelleştirmeleri kontrol ETME',
    'updates_enable_check'                      => 'Güncelleme kontrolünü etkinleştir',
    'admin_update_check_now_title'              => 'Güncellemeleri kontrol et',
    'admin_update_check_now_explain'            => 'Düğmeye basarsanız, Firefly III geçerli sürümünüzün en son olup olmadığını görür.',
    'check_for_updates_button'                  => 'Kontrol Et!',
    'update_new_version_alert'                  => 'Firefly III\'ün yeni versiyonu mevcut. Şuan kullandığınız :your_version, son versiyon ise :date tarihinde yayınlanan :new_version versiyonu.',
    'update_version_beta'                       => 'Bu bir BETA versiyonudur. Bazı hatalar ile karşılaşabilirsiniz.',
    'update_version_alpha'                      => 'Bu bir ALPHA versiyonudur. Bazı hatalar ile karşılaşabilirsiniz.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'En son mevcut olan :version versiyonunu kullanıyorsunuz.',
    'update_newer_version_alert'                => 'Son mevcut olan :new_version versiyonundan daha yeni olan :your_version versiyonu kullanıyorsunuz.',
    'update_check_error'                        => 'Güncellemeler kontrol edilirken bir hata oluştu: :error',
    'unknown_error'                             => 'Bilinmeyen hata. Bunun için üzgünüm.',
    'disabled_but_check'                        => 'Güncelleme kontrolünü devre dışı bıraktınız. Bu nedenle, ara sıra güncellemeleri kendiniz kontrol etmeyi unutmayın. Teşekkürler!',
    'admin_update_channel_title'                => 'Güncelleme kanalı',
    'admin_update_channel_explain'              => 'Firefly III 3 adet güncelleme kanalına sahiptir. Bu kanallar sizin özellikler, geliştirmeler ve hatalar ile ilgili ne kadar önde olduğunuzu belirler. Maceracası iseniz "beta", tehlikeli yaşamayı seviyorsanız "alpha" versiyonunu kullanın.',
    'update_channel_stable'                     => 'Stabil. Herşey olması gerektiği gibi.',
    'update_channel_beta'                       => 'Beta. Yeni özellikler fakat bazı şeyler bozulabilir.',
    'update_channel_alpha'                      => 'Alpha. İçine ne bulursak atıp, uygun olanı kullanıyoruz.',

    // search
    'search'                                    => 'Ara',
    'search_query'                              => 'Sorgu',
    'search_found_transactions'                 => 'Firefly III bulundu :count :time saniye cinsinden sayar.|Firefly III bulundu :count :time saniye cinsinden sayar.',
    'search_found_more_transactions'            => 'Firefly III, :time saniye cinsinden :count işlemlerinden fazlasını buldu.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Bu arama parametreleri geçerli değil ve yok sayıldı.',

    // old


    'search_modifier_date_on'                             => 'Transaction date is ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Transfer Kimliği ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'İşlem tarihi ":value" dan önce veya üzerinde',
    'search_modifier_date_after'                          => 'İşlem tarihi ":value" dan sonra veya üzerinde',
    'search_modifier_external_id_is'                      => 'External ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'External ID is not ":value"',
    'search_modifier_no_external_url'                     => 'İşlemin harici URL\'si yok',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'The transaction has no external URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'İşlemin (herhangi bir) harici URL\'si olmalıdır',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'The transaction must have a (any) external URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Internal reference is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Internal reference is not ":value"',
    'search_modifier_description_starts'                  => 'Description starts with ":value"',
    'search_modifier_not_description_starts'              => 'Description does not start with ":value"',
    'search_modifier_description_ends'                    => 'Description ends on ":value"',
    'search_modifier_not_description_ends'                => 'Description does not end on ":value"',
    'search_modifier_description_contains'                => 'Açıklama ":value" içeriyor',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Açıklama tam olarak ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => 'İşlem (yabancı) para birimi ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'İşlem yabancı para birimi ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'İşlemin bir eki olmalıdır',
    'search_modifier_has_no_category'                     => 'İşlemin kategorisi olmamalıdır',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'İşlemin bir (herhangi bir) kategorisi olmalıdır',
    'search_modifier_has_no_budget'                       => 'İşlemin bütçesi olmamalıdır',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'İşlemin (herhangi bir) bütçesi olmalıdır',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'İşlemin etiketi olmamalıdır',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'İşlemin bir (herhangi bir) etiketi olmalıdır',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'İşlemin notu yok',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'İşlemin notları olmalıdır',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Amount is exactly :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Tutar şundan küçük veya şuna eşit ":value"',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Tutar şundan büyük veya eşittir :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Kaynak hesap adı tam olarak ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Kaynak hesap adı ":value" içeriyor',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Kaynak hesap adı ":value" ile başlar',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Kaynak hesap adı ":value" ile biter',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'Kaynak hesap kimliği :value',
    'search_modifier_not_source_account_id'               => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                => 'Kaynak hesap numarası (IBAN) ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Kaynak hesap numarası (IBAN) ":value" içeriyor',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Kaynak hesap numarası (IBAN) ":value" ile başlar',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Hedef hesap adı tam olarak ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Hedef hesap adı ":value" içeriyor',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Hedef hesap adı ":value" ile başlar',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Hedef hesap kimliği :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Hedef hesap numarası (IBAN) ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Hedef hesap numarası (IBAN) ":value" içeriyor',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Hedef hesap numarası (IBAN) ":value" ile başlar',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Hedef hesap numarası (IBAN) ":value" ile biter',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Kaynak veya hedef hesap kimlikleri: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Kategori ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'Bütçe ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'İşlem türü ":value"',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'Etiket şu şekildedir:value',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'İşlem öncesi veya yıl içinde yapılır ":value"',
    'search_modifier_date_before_month'                   => 'İşlem ay önce ya ":value"',
    'search_modifier_date_before_day'                     => 'İşlem ayın öncesinde veya günündedir ":value"',
    'search_modifier_date_after_year'                     => 'İşlem bir yıl içinde veya sonrasında gerçekleşir ":value"',
    'search_modifier_date_after_month'                    => 'İşlem ay içinde veya sonrasında ":value"',
    'search_modifier_date_after_day'                      => 'İşlem, ayın sonunda veya gününde gerçekleşir ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Arama sorgusundan ":rule" kuralını güncelle',
    'create_rule_from_query'                        => 'Arama sorgusundan yeni kural oluşturma',
    'rule_from_search_words'                        => 'Kural altyapısı ":string" işlemekte zorlanıyor. Arama sorgunuza uyan önerilen kural farklı sonuçlar verebilir. Lütfen kural tetikleyicilerini dikkatlice doğrulayın.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Arama yaparken hata oluştu. Lütfen daha fazla bilgi için kütük dosyalarına göz atınız.',
    'search_box'                                          => 'Ara',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Arama sırasında hata oluştu',
    'search_searching'                                    => 'Aranıyor ...',
    'search_results'                                      => 'Arama sonuçları',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'yıllık',
    'repeat_freq_half-year'                               => 'her yarı yıl',
    'repeat_freq_quarterly'                               => 'üç aylık',
    'repeat_freq_monthly'                                 => 'aylık',
    'repeat_freq_weekly'                                  => 'haftalık',
    'repeat_freq_daily'                                   => 'günlük',
    'daily'                                               => 'günlük',
    'weekly'                                              => 'haftalık',
    'quarterly'                                           => 'üç aylık',
    'half-year'                                           => 'her yarı yıl',
    'yearly'                                              => 'yıllık',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Etkin olmayan kuralları yürütemezsiniz.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Kurallar',
    'rule_name'                                           => 'Kural adı',
    'rule_triggers'                                       => 'Kural ne zaman etkinleşir',
    'rule_actions'                                        => 'Kural olacak',
    'new_rule'                                            => 'Yeni kural',
    'new_rule_group'                                      => 'Yeni kural grubu',
    'rule_priority_up'                                    => 'Kurala daha fazla öncelik ver',
    'rule_priority_down'                                  => 'Kurala daha az öncelik ver',
    'make_new_rule_group'                                 => 'Yeni kural grubu oluştur',
    'store_new_rule_group'                                => 'Yeni kural grubunu kaydet',
    'created_new_rule_group'                              => 'Yeni kural grubu ":title" saklandı!',
    'updated_rule_group'                                  => 'Başarıyla güncellenen kural grubu ":title".',
    'edit_rule_group'                                     => '":title" kural grubunu düzenle',
    'duplicate_rule'                                      => 'Yinelenen kural ":title"',
    'rule_copy_of'                                        => 'Kopyası ":title"',
    'duplicated_rule'                                     => 'Çoğaltılmış kural ":title" içinde ":newTitle"',
    'delete_rule_group'                                   => '":title" kural grubunu sil',
    'deleted_rule_group'                                  => 'Silinen kural grubu ":title"',
    'update_rule_group'                                   => 'Grup bilgilerini güncelle',
    'no_rules_in_group'                                   => 'Bu grupta kural yok',
    'move_rule_group_up'                                  => 'Grup kuralını yukarı taşı',
    'move_rule_group_down'                                => 'Grup kuralını aşağı taşı',
    'save_rules_by_moving'                                => 'Bu kuralı başka bir kural grubuna taşıyarak kaydedin:|Bu kuralları başka bir kural grubuna taşıyarak kaydedin:',
    'make_new_rule'                                       => '":title" kural grubunda yeni kural oluşturun',
    'make_new_rule_no_group'                              => 'Yeni bir kural ekleyin',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'İşlemlerinizden birini temel alan bir kural oluşturun. Aşağıdaki formu tamamlayın veya gönderin.',
    'rule_is_strict'                                      => 'sıkı kural',
    'rule_is_not_strict'                                  => 'sıkı olmayan kural',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'Katı kuraldayken aksiyonun gerçekleşmesi için tüm tetikleyiciler tetiklenmelidir. Katı olmayan kuraldayken herhangi bir tetikleyicinin tetiklenmesi aksiyonun gerçekleşmesine yeterlidir.',
    'rule_help_active'                                    => 'Aktif olmayan kurallar asla çalışmaz.',
    'stored_new_rule'                                     => '":title" başlığıyla saklanmış yeni kural',
    'deleted_rule'                                        => '":title" başlığıyla saklanmış kuralı sil',
    'store_new_rule'                                      => 'Yeni kural sakla',
    'updated_rule'                                        => '":title" başlığı ile la güncellenmiş kural',
    'default_rule_group_name'                             => 'Varsayılan kurallar',
    'default_rule_group_description'                      => 'Tüm kurallarınız belli bir grupta değil.',
    'trigger'                                             => 'Tetikleyici',
    'trigger_value'                                       => 'Değer üzerindeki tetikleyici',
    'stop_processing_other_triggers'                      => 'Diğer tetikleyicilerin işlenmesini durdur',
    'add_rule_trigger'                                    => 'Yeni tetikleyici ekle',
    'action'                                              => 'Eylem',
    'action_value'                                        => 'Eylem değeri',
    'stop_executing_other_actions'                        => 'Diğer işlemleri yürütmeyi durdur',
    'add_rule_action'                                     => 'Yeni eylem ekle',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => '":title" kuralını sil',
    'update_rule'                                         => 'Güncelleme kuralları',
    'test_rule_triggers'                                  => 'Eşleşen işlemleri görün',
    'warning_no_matching_transactions'                    => 'Eşleşen işlem bulunamadı.',
    'warning_no_valid_triggers'                           => 'Geçerli tetikleyiciler sağlanmadı.',
    'apply_rule_selection'                                => 'İşleminizin bir bölümüne ":title" kuralını uygulayın',
    'apply_rule_selection_intro'                          => '":title" gibi kurallar normalde sadece yeni ve güncellenen işlemlerde geçerlidir ama Firefly III\'e onları mevcut işlemlerinizin istediğiniz bölümlerinde uygulanmasını söyleyebilirsiniz. Bu bir kuralı değiştirdiğinizde ve bunun diğer tüm işlemlerde uygulanmasını istediğinizde yararlı olabilir.',
    'include_transactions_from_accounts'                  => 'Bu hesaplardan gelen işlemleri dahil et',
    'include'                                             => 'Vardır?',
    'applied_rule_selection'                              => '{0} Seçiminizdeki hiçbir işlem kural tarafından değiştirilmedi ":title".|[1] Seçiminizdeki bir işlem kuralla değiştirildi":title".|[2,*] :seçiminizdeki sayım işlemleri kurala göre değiştirildi ":title".',
    'execute'                                             => 'Çalıştır',
    'apply_rule_group_selection'                          => 'İşlemlerinizin bir bölümüne ":title" kural grubunu uygulayın',
    'apply_rule_group_selection_intro'                    => '":title" gibi kural grupları normalde sadece yeni ve güncellenen işlemlerde geçerlidir ama Firefly III\'e onları mevcut işlemlerinizin istediğiniz bölümlerinde uygulanmasını söyleyebilirsiniz. Bu bir kural grubunu değiştirdiğinizde ve bunun diğer tüm işlemlerde uygulanmasını istediğinizde yararlı olabilir.',
    'applied_rule_group_selection'                        => 'Seçeneğinize ":title" kuralı uygulandı.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Bir işlem oluşturulduğunda',
    'rule_trigger_update_journal'                         => 'Bir işlem güncellendiğinde',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Kullanıcı işlemi ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Kaynak hesap adı ile başlar..',
    'rule_trigger_source_account_starts'                  => 'Kaynak hesap adı şununla başlar ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Source account name ends with..',
    'rule_trigger_source_account_ends'                    => 'Kaynak hesap adı şununla biter ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Kaynak hesap adıdır..',
    'rule_trigger_source_account_is'                      => 'Kaynak hesap adı":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Kaynak hesap adı içerir..',
    'rule_trigger_source_account_contains'                => 'Kaynak hesap adı şunları içerir ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Kaynak hesap kimliği tam olarak..',
    'rule_trigger_source_account_id'                      => 'Kaynak hesap kimliği tam olarak :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Hedef hesap kimliği tam olarak..',
    'rule_trigger_destination_account_id'                 => 'Hedef hesap kimliği tam olarak :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Kaynak hesap (nakit) hesaptır',
    'rule_trigger_source_is_cash'                         => 'Kaynak hesap (nakit) hesaptır',
    'rule_trigger_destination_is_cash_choice'             => 'Hedef hesap (nakit) hesaptır',
    'rule_trigger_destination_is_cash'                    => 'Hedef hesap (nakit) hesaptır',
    'rule_trigger_source_account_nr_starts_choice'        => 'Kaynak hesap numarası / IBAN ile başlar..',
    'rule_trigger_source_account_nr_starts'               => 'Kaynak hesap numarası / IBAN ile başlar ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Kaynak hesap numarası / IBAN ile biter..',
    'rule_trigger_source_account_nr_ends'                 => 'Kaynak hesap numarası / IBAN ile biter ":trigger_value',
    'rule_trigger_source_account_nr_is_choice'            => 'Kaynak hesap numarası / IBAN..',
    'rule_trigger_source_account_nr_is'                   => 'Kaynak hesap numarası / IBAN ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Kaynak hesap numarası / IBAN içerir..',
    'rule_trigger_source_account_nr_contains'             => 'Source account number / IBAN contains:trigger_value',
    'rule_trigger_destination_account_starts_choice'      => 'Hedef hesap adı ile başlar..',
    'rule_trigger_destination_account_starts'             => 'Hedef hesap adı şununla başlar ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Hedef hesap adı ile biter..',
    'rule_trigger_destination_account_ends'               => 'Hedef hesap adı şununla biter ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Hedef hesap adıdır..',
    'rule_trigger_destination_account_is'                 => 'Hedef hesap adı":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Hedef hesap adı içerir..',
    'rule_trigger_destination_account_contains'           => 'Hedef hesap adı şunları içerir ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Hedef hesap numarası / IBAN ile başlar..',
    'rule_trigger_destination_account_nr_starts'          => 'Hedef hesap numarası / IBAN ":trigger_value" ile başlar',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Hedef hesap numarası / IBAN ile biter..',
    'rule_trigger_destination_account_nr_ends'            => 'Hedef hesap numarası / IBAN ":trigger_value" ile bitiyor',
    'rule_trigger_destination_account_nr_is_choice'       => 'Hedef hesap numarası / IBAN\'dır..',
    'rule_trigger_destination_account_nr_is'              => 'Hedef hesap numarası / IBAN: ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Hedef hesap numarası / IBAN içerir..',
    'rule_trigger_destination_account_nr_contains'        => 'Hedef hesap numarası / IBAN içerir ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'İşlem türü..',
    'rule_trigger_transaction_type'                       => 'İşlem türü ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategori..',
    'rule_trigger_category_is'                            => 'Kategori ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Açıklama başlıyor..',
    'rule_trigger_description_starts'                     => 'Açıklama ":trigger_value" ile başlar',
    'rule_trigger_description_ends_choice'                => 'Açıklama bitiyor..',
    'rule_trigger_description_ends'                       => 'Açıklama ":trigger_value" ile bitiyor',
    'rule_trigger_description_contains_choice'            => 'Açıklama içerir..',
    'rule_trigger_description_contains'                   => 'Açıklama ":trigger_value" içerir',
    'rule_trigger_description_is_choice'                  => 'Açıklama..',
    'rule_trigger_description_is'                         => 'Açıklama ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'İşlem tarihi öncedir..',
    'rule_trigger_date_before'                            => 'İşlem tarihi önce:trigger_value',
    'rule_trigger_date_after_choice'                      => 'İşlem tarihi sonradır..',
    'rule_trigger_date_after'                             => 'İşlem tarihi:trigger_value sonrasıdır',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Bütçe..',
    'rule_trigger_budget_is'                              => 'Bütçe ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'İşlem dövizi..',
    'rule_trigger_currency_is'                            => 'İşlem dövizi ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'İşlem dövizdir..',
    'rule_trigger_foreign_currency_is'                    => 'İşlem yabancı para birimi:trigger_value',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Kategorisi yok',
    'rule_trigger_has_no_category'                        => 'İşlemin kategorisi yok',
    'rule_trigger_has_any_category_choice'                => 'Bir kategorisi var',
    'rule_trigger_has_any_category'                       => 'İşlemin bir kategorisi var',
    'rule_trigger_has_no_budget_choice'                   => 'Bütçe yok',
    'rule_trigger_has_no_budget'                          => 'İşlem bütçesi yok',
    'rule_trigger_has_any_budget_choice'                  => 'Bir bütçesi var',
    'rule_trigger_has_any_budget'                         => 'İşlemin bir bütçesi var',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Etiket yok',
    'rule_trigger_has_no_tag'                             => 'İşlemin etiketi yok',
    'rule_trigger_has_any_tag_choice'                     => 'Bir veya birçok etiketleri var',
    'rule_trigger_has_any_tag'                            => 'İşlemin bir veya birçok etiketi var',
    'rule_trigger_any_notes_choice'                       => 'Notları var',
    'rule_trigger_any_notes'                              => 'İşlemin notları var',
    'rule_trigger_no_notes_choice'                        => 'Notu yok',
    'rule_trigger_no_notes'                               => 'İşlemin notu yok',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'İşlem günlüğü kimliğidir..',
    'rule_trigger_journal_id'                             => 'İşlem günlüğü kimliği:trigger_value',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'İşlemin harici URL\'si yok',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'İşlem kimliğidir..',
    'rule_trigger_id'                                     => 'İşlem kimliği:trigger_value',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Kategoriyi ":action_value" olarak ayarla',
    'rule_action_clear_category'                 => 'Kategoriyi temizle',
    'rule_action_set_budget'                     => 'Bütçeyi ":action_value" olarak ayarlayın',
    'rule_action_clear_budget'                   => 'Bütçeyi temizle',
    'rule_action_add_tag'                        => '":action_value" etiketi ekle',
    'rule_action_remove_tag'                     => '":action_value" etiketini kaldır',
    'rule_action_remove_all_tags'                => 'Tüm etiketleri kaldır',
    'rule_action_set_description'                => 'Açıklamayı ":action_value" olarak ayarla',
    'rule_action_append_description'             => 'Açıklamayı ":action_value" ile ekle',
    'rule_action_prepend_description'            => 'Açıklamayı ":action_value" ile ekleyin',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Tüm kategoriyi temizle',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Herhangi bir bütçeyi temizle',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Tüm etiketleri kaldır',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Kaynak hesaba :action_value ayarlayınız',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Hedef hesaba :action_value ayarlayınız',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => '":action_value" ile not ekle',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Notlarına başına ":action_value" ekleyiniz',
    'rule_action_clear_notes_choice'             => 'Herhangi bir notu kaldır',
    'rule_action_clear_notes'                    => 'Herhangi bir notu kaldır',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Notları ":action_value" olarak ayarla',
    'rule_action_convert_deposit_choice'         => 'İşlemi mevduata dönüştür',
    'rule_action_convert_deposit'                => 'İşlemi ":action_value" mevduatına dönüştür',
    'rule_action_convert_withdrawal_choice'      => 'İşlemi para çekmeye dönüştür',
    'rule_action_convert_withdrawal'             => 'İşlemi ":action_value" para çekmeye dönüştür',
    'rule_action_convert_transfer_choice'        => 'İşlemi transfere dönüştür',
    'rule_action_convert_transfer'               => 'İşlemi ":action_value" transferine dönüştür',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'İşleme dayalı kural ":description"',
    'new_rule_for_journal_description'          => 'Bu kural işleme dayanmaktadır ":description". Tam olarak aynı olan işlemlerle eşleşecektir.',

    // tags
    'store_new_tag'                             => 'Yeni etiket kaydet',
    'update_tag'                                => 'Etiketi Güncelle',
    'no_location_set'                           => 'Konum ayarlanamadı.',
    'meta_data'                                 => 'Meta veri',
    'location'                                  => 'Konum',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Tarihsiz',
    'result'                                    => 'Sonuç',
    'sums_apply_to_range'                       => 'Tüm toplamlar seçili aralıkta geçerlidir',
    'mapbox_api_key'                            => 'Map\'i kullanmak için şu adresten bir API anahtarı alın: <a href="https://www.mapbox.com/">Mapbox</a>. Seninkini aç <code>.env</code> dosyalayın ve sonra bu kodu girin <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Nesnenin konumunu ayarlamak için sağ tıklayın veya uzun basın.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Konumu temizle',
    'delete_all_selected_tags'                  => 'Seçili tüm etiketleri sil',
    'select_tags_to_delete'                     => 'Bazı etiketler seçmeyi unutmayın.',
    'deleted_x_tags'                            => 'Silmek :count etiket.|Silmek :count etiket.',
    'create_rule_from_transaction'              => 'İşleme dayalı kural oluşturma',
    'create_recurring_from_transaction'         => 'İşleme dayalı yinelenen işlem oluşturma',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(dile eşit)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Ana ekran hesapları',
    'pref_home_screen_accounts_help'            => 'Giriş sayfasında hangi hesaplar görüntülensin?',
    'pref_view_range'                           => 'Görüş Mesafesi',
    'pref_view_range_help'                      => 'Bazı grafikler otomatik olarak dönemler halinde gruplandırılır. Bütçeleriniz de dönemlere göre gruplandırılacaktır. Hangi dönemi tercih edersin?',
    'pref_1D'                                   => 'Bir gün',
    'pref_1W'                                   => 'Bir hafta',
    'pref_1M'                                   => 'Bir ay',
    'pref_3M'                                   => 'Üç ay (çeyrek)',
    'pref_6M'                                   => 'Altı ay',
    'pref_1Y'                                   => 'Bir yıl',
    'pref_last365'                              => 'Geçen yıl',
    'pref_last90'                               => 'Son 90 gün',
    'pref_last30'                               => 'Son 30 gün',
    'pref_last7'                                => 'Son 7 gün',
    'pref_YTD'                                  => 'Yıldan bugüne',
    'pref_QTD'                                  => 'Bugüne kadar tarih',
    'pref_MTD'                                  => 'Bugüne kadar ay',
    'pref_languages'                            => 'Diller',
    'pref_locale'                               => 'Yerel ayarlar',
    'pref_languages_help'                       => 'Firefly III birçok dili destekliyor. Hangisini tercih edersiniz?',
    'pref_locale_help'                          => 'Firefly III, para birimlerinin, sayıların ve tarihlerin nasıl biçimlendirildiği gibi diğer yerel ayarları ayarlamanıza olanak tanır. Bu listedeki girdiler sisteminiz tarafından desteklenmeyebilir. Firefly III her yerel ayar için doğru tarih ayarlarına sahip değil; iyileştirmeler için bana ulaşın.',
    'pref_locale_no_demo'                       => 'Bu özellik demo kullanıcısı için çalışmaz.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Mali yıl ayarları',
    'pref_custom_fiscal_year_label'             => 'Etkin',
    'pref_custom_fiscal_year_help'              => '1 Ocak - 31 Aralık arasındaki bir mali yılı kullanan ülkelerde bu ayarı açabilir ve mali yılın başlangıç / bitiş günlerini belirleyebilirsiniz',
    'pref_fiscal_year_start_label'              => 'Mali yıl başlangıç tarihi',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Kimlik hesabı doğrulama uygulaması için çıkış yapmayı unutmayın!',
    'pref_two_factor_auth_code'                 => 'Doğrulama kodu',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Doğrulama kodunu sıfırla',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'QR kodunu tarayamıyorsanız, bunun yerine sırrı kullanmaktan çekinmeyin: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Cihazınızı kaybetmeniz durumunda erişim için bu yedekleme kodlarını saklayın.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Bu MFA kodu geçerli değil.',
    'pref_save_settings'                        => 'Ayarları kaydet',
    'saved_preferences'                         => 'Tercihler kaydedildi!',
    'preferences_general'                       => 'Genel',
    'preferences_frontpage'                     => 'Ana ekran',
    'preferences_security'                      => 'Güvenlik',
    'preferences_layout'                        => 'Düzen',
    'preferences_notifications'                 => 'Bildirimler',
    'pref_home_show_deposits'                   => 'Ana ekranda mevduat göster',
    'pref_home_show_deposits_info'              => 'Ana ekranınızda hesaplarınız zaten görüntülenir. Gelir hesaplarınız da görüntülensin mi?',
    'pref_home_do_show_deposits'                => 'Evet, onlara göster',
    'successful_count'                          => ':count bunlar başarılı oldu',
    'list_page_size_title'                      => 'Sayfa boyutu',
    'list_page_size_help'                       => 'Herhangi bir şeyin listesi (hesaplar, işlemler, vb) sayfa başına en fazla bu kadar gösterebilir.',
    'list_page_size_label'                      => 'Sayfa boyutu',
    'between_dates'                             => '(:start ​ve :end)',
    'pref_optional_fields_transaction'          => 'İşlemler için bağlı alanlar',
    'pref_optional_fields_transaction_help'     => 'Yeni bir işlem oluşturulurken (dağınıklık nedeniyle) varsayılan olarak tüm alanlar ektinleştirilmez. Aşağıdan, eğer işinize yarayacağını düşünüyorsanız bu alanları ektinleştirebilirsiniz. Tabii ki, devre dışı bırakılmış ama zaten doldurulmuş alanlar ayarlar ne olursa olsun görünecektir.',
    'optional_tj_date_fields'                   => 'Tarih alanları',
    'optional_tj_other_fields'                  => 'Diğer alanlar',
    'optional_tj_attachment_fields'             => 'Ek alanları',
    'pref_optional_tj_interest_date'            => 'Faiz tarihi',
    'pref_optional_tj_book_date'                => 'Kitap tarihi',
    'pref_optional_tj_process_date'             => 'İşlem tarihi',
    'pref_optional_tj_due_date'                 => 'Bitiş tarihi',
    'pref_optional_tj_payment_date'             => 'Ödeme tarihi',
    'pref_optional_tj_invoice_date'             => 'Fatura tarihi',
    'pref_optional_tj_internal_reference'       => 'Dahili referans',
    'pref_optional_tj_notes'                    => 'Notlar',
    'pref_optional_tj_attachments'              => 'Ekler',
    'pref_optional_tj_external_url'             => 'Dış URL',
    'pref_optional_tj_location'                 => 'Konum',
    'pref_optional_tj_links'                    => 'İşlem bağlantıları',
    'optional_field_meta_dates'                 => 'Tarih',
    'optional_field_meta_business'              => 'İş',
    'optional_field_attachments'                => 'Ekler',
    'optional_field_meta_data'                  => 'İsteğe bağlı meta veriler',
    'external_url'                              => 'Harici URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Bildirimler',
    'pref_notifications_help'                   => 'Bu bildirimleri almak isteyip istemediğinizi belirtin. Bazı bildirimler hassas finansal bilgiler içerebilir.',
    'pref_notifications_settings'               => 'Bildirim ayarları',
    'pref_notifications_settings_help'          => 'Bu ayarları kullanarak bildirim kanallarınızı yapılandırın. Bildirimlerin TÜM kanallara gönderileceğini lütfen unutmayın. Lütfen ÖNCE ayarlarınızı kaydedin.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Diğer tüm oturumlarınız kapatıldı.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Diğer tüm seanslarınız kapatıldı',
    'delete_all_categories'                     => 'TÜM kategorilerinizi silme',
    'delete_all_tags'                           => 'TÜM etiketlerinizi silin',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'TÜM kumbaralarınızı silin',
    'delete_all_rules'                          => 'TÜM kurallarınızı silin',
    'delete_all_recurring'                      => 'Yinelenen tüm işlemlerinizi silme',
    'delete_all_object_groups'                  => 'TÜM nesne gruplarınızı silme',
    'delete_all_accounts'                       => 'TÜM hesaplarınızı silin',
    'delete_all_asset_accounts'                 => 'Delete ALL your asset accounts',
    'delete_all_expense_accounts'               => 'Delete ALL your expense accounts',
    'delete_all_revenue_accounts'               => 'Delete ALL your revenue accounts',
    'delete_all_liabilities'                    => 'Delete ALL your liabilities',
    'delete_all_transactions'                   => 'Delete ALL your transactions',
    'delete_all_withdrawals'                    => 'Delete ALL your withdrawals',
    'delete_all_deposits'                       => 'Delete ALL your deposits',
    'delete_all_transfers'                      => 'Delete ALL your transfers',
    'also_delete_transactions'                  => 'Deleting accounts will also delete ALL associated withdrawals, deposits and transfers!',
    'deleted_all_budgets'                       => 'All budgets have been deleted',
    'deleted_all_categories'                    => 'All categories have been deleted',
    'deleted_all_tags'                          => 'All tags have been deleted',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'All piggy banks have been deleted',
    'deleted_all_rules'                         => 'All rules and rule groups have been deleted',
    'deleted_all_object_groups'                 => 'All groups have been deleted',
    'deleted_all_accounts'                      => 'All accounts have been deleted',
    'deleted_all_asset_accounts'                => 'All asset accounts have been deleted',
    'deleted_all_expense_accounts'              => 'All expense accounts have been deleted',
    'deleted_all_revenue_accounts'              => 'All revenue accounts have been deleted',
    'deleted_all_liabilities'                   => 'All liabilities have been deleted',
    'deleted_all_transactions'                  => 'All transactions have been deleted',
    'deleted_all_withdrawals'                   => 'All withdrawals have been deleted',
    'deleted_all_deposits'                      => 'All deposits have been deleted',
    'deleted_all_transfers'                     => 'All transfers have been deleted',
    'deleted_all_recurring'                     => 'All recurring transactions have been deleted',
    'change_your_password'                      => 'Şifrenizi değiştirin',
    'delete_account'                            => 'Hesabı Sil',
    'current_password'                          => 'Güncel Şifre',
    'new_password'                              => 'Yeni Şifre',
    'new_password_again'                        => 'Yeni Şifre (Tekrar)',
    'delete_your_account'                       => 'Hesabını Sil',
    'delete_your_account_help'                  => 'Hesabınızı silmeniz aynı zamanda Firefly III\'e kaydetmiş olabileceğiniz hesapları, işlemleri, <em>her şeyi</em> de silecektir. YOK OLACAK.',
    'delete_your_account_password'              => 'Devam etmek için şifrenizi girin.',
    'password'                                  => 'Şifre',
    'are_you_sure'                              => 'Emin misiniz? Bunu geri alamazsınız.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'Hesabını Sil',
    'invalid_current_password'                  => 'Geçersiz Şifre!',
    'password_changed'                          => 'Şifre değiştirildi!',
    'should_change'                             => 'Amaç, şifrenizi değiştirmenizdir.',
    'invalid_password'                          => 'Geçersiz şifre!',
    'what_is_pw_security'                       => '\'\'Doğrulama şifresi güvenliği\'\' nedir?',
    'secure_pw_title'                           => 'Güvenli şifre nasıl seçilir?',
    'forgot_password_response'                  => 'Thank you. If an account exists with this email address, you will find instructions in your inbox.',
    'secure_pw_history'                         => 'Not a week goes by that you read in the news about a site losing the passwords of its users. Hackers and thieves use these passwords to try to steal your private information. This information is valuable.',
    'secure_pw_ff'                              => 'Do you use the same password all over the internet? If one site loses your password, hackers have access to all your data. Firefly III relies on you to choose a strong and unique password to protect your financial records.',
    'secure_pw_check_box'                       => 'To help you do that Firefly III can check if the password you want to use has been stolen in the past. If this is the case, Firefly III advises you NOT to use that password.',
    'secure_pw_working_title'                   => 'How does it work?',
    'secure_pw_working'                         => 'By checking the box, Firefly III will send the first five characters of the SHA1 hash of your password to <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">the website of Troy Hunt</a> to see if it is on the list. This will stop you from using unsafe passwords as is recommended in the latest <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> on this subject.',
    'secure_pw_should'                          => 'Kutuyu kontrol etmeli miyim?',
    'secure_pw_long_password'                   => 'Yes. Always verify your password is safe.',
    'command_line_token'                        => 'Command line token',
    'explain_command_line_token'                => 'You need this token to perform command line options, such as exporting data. Without it, that sensitive command will not work. Do not share your command line token. Nobody will ask you for this token, not even me. If you fear you lost this, or when you\'re paranoid, regenerate this token using the button.',
    'regenerate_command_line_token'             => 'Regenerate command line token',
    'token_regenerated'                         => 'A new command line token was generated',
    'change_your_email'                         => 'E-posta adresini değiştir',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'E-posta adresinizi doğrulayana kadar giriş yapamazsınız.',
    'login_with_new_email'                      => 'Artık yeni e-posta adresinizle giriş yapabilirsiniz.',
    'login_with_old_email'                      => 'Artık eski e-posta adresinizle yeniden giriş yapabilirsiniz.',
    'login_provider_local_only'                 => 'This action is not available when authenticating through ":login_provider".',
    'external_user_mgt_disabled'                => 'This action is not available when Firefly III isn\'t responsible for user management or authentication handling.',
    'external_auth_disabled'                    => 'This action is not available when Firefly III isn\'t responsible for authentication handling.',
    'delete_local_info_only'                    => "Because Firefly III isn't responsible for user management or authentication handling, this function will only delete local Firefly III information.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth Clients',
    'profile_oauth_no_clients'                  => 'You have not created any OAuth clients.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'Client ID',
    'profile_oauth_client_name'                 => 'Name',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Create New Client',
    'profile_oauth_create_client'               => 'Müşteri Oluştur',
    'profile_oauth_edit_client'                 => 'İstemciyi Düzenle',
    'profile_oauth_name_help'                   => 'Kullanıcılarınızın tanıyacağı ve güveneceği bir şey.',
    'profile_oauth_redirect_url'                => 'URL\'yi yönlendir',
    'profile_oauth_redirect_url_help'           => 'Uygulamanızın yetkilendirme geri arama URL\'si.',
    'profile_authorized_apps'                   => 'Yetkili uygulamalar',
    'profile_authorized_clients'                => 'Yetkili müşteriler',
    'profile_scopes'                            => 'Kapsamalar',
    'profile_revoke'                            => 'İptal etmek',
    'profile_oauth_client_secret_title'         => 'Müşteri Sırrı',
    'profile_oauth_client_secret_expl'          => 'İşte yeni müşteri sırrın. Bu gösterilecek tek zaman, bu yüzden onu kaybetme! Artık API istekleri yapmak için bu sırrı kullanabilirsiniz.',
    'profile_personal_access_tokens'            => 'Kişisel Erişim Belirteçleri',
    'profile_personal_access_token'             => 'Kişisel Erişim Belirteci',
    'profile_oauth_confidential'                => 'Gizli',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'İşte yeni kişisel erişim belirteciniz. Bu gösterilecek tek zaman, bu yüzden onu kaybetme! Artık API istekleri yapmak için bu belirtecini kullanabilirsiniz.',
    'profile_no_personal_access_token'          => 'Herhangi bir kişisel erişim belirteci oluşturmadınız.',
    'profile_create_new_token'                  => 'Yeni belirteç oluştur',
    'profile_create_token'                      => 'Belirteç oluştur',
    'profile_create'                            => 'Belirteç oluşturma',
    'profile_save_changes'                      => 'Değişiklikleri kaydet',
    'profile_whoops'                            => 'Hoppala!',
    'profile_something_wrong'                   => 'Bir şeyler ters gitti!',
    'profile_try_again'                         => 'Bir şeyler yanlış gitti. Lütfen tekrar deneyin.',
    'amounts'                                   => 'Miktarlar',
    'multi_account_warning_unknown'             => 'Oluşturduğunuz işlemin türüne bağlı olarak, sonraki bölünmelerin kaynak ve / veya hedef hesabı, işlemin ilk bölünmesinde tanımlanan her şey tarafından geçersiz kılınabilir.',
    'multi_account_warning_withdrawal'          => 'Sonraki bölünmelerin kaynak hesabının, geri çekilmenin ilk bölünmesinde tanımlanan herhangi bir şey tarafından reddedileceğini unutmayın.',
    'multi_account_warning_deposit'             => 'Sonraki bölünmelerin hedef hesabının, mevduatın ilk bölünmesinde tanımlanan herhangi bir şey tarafından iptal edileceğini unutmayın.',
    'multi_account_warning_transfer'            => 'Sonraki bölünmelerin kaynak + hedef hesabının, aktarımın ilk bölünmesinde tanımlanan her şey tarafından geçersiz kılınacağını unutmayın.',


    // export data:
    'export_data_title'                         => 'Export data from Firefly III',
    'export_data_menu'                          => 'Verileri dışa aktar',
    'export_data_bc'                            => 'Firefly III \'ten veri dışa aktarma',
    'export_data_main_title'                    => 'Firefly III \'ten veri dışa aktarma',
    'export_data_expl'                          => 'Bu bağlantı, tüm işlemleri + meta verilerini Firefly ııı\'ten dışa aktarmanıza olanak tanır. Lütfen yardıma bakın (sağ üstte (?)-simge) işlem hakkında daha fazla bilgi için.',
    'export_data_all_transactions'              => 'Tüm işlemleri dışa aktar',
    'export_data_advanced_expl'                 => 'Daha gelişmiş veya belirli bir dışa aktarma türüne ihtiyacınız varsa, konsol komutunun nasıl kullanılacağına ilişkin yardımı okuyun <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Bir eklenti |:count eklenti',
    'attachments'                               => 'Ekler',
    'edit_attachment'                           => 'Ek ":name" düzenle',
    'update_attachment'                         => 'Eki güncelle',
    'delete_attachment'                         => '":name" Eki sil',
    'attachment_deleted'                        => '":name" eki silindi',
    'liabilities_deleted'                       => 'Silinen sorumluluk ":name"',
    'attachment_updated'                        => '":name" Ek güncellendi',
    'upload_max_file_size'                      => 'Maksimum dosya boyutu: :size',
    'list_all_attachments'                      => 'Tüm eklerin listesi',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Giderler',
    'title_withdrawal'                          => 'Giderler',
    'title_revenue'                             => 'Gelir / Gelir',
    'title_deposit'                             => 'Gelir / Gelir',
    'title_transfer'                            => 'Transferler',
    'title_transfers'                           => 'Transferler',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Bu işlem zaten bir para çekme işlemidir',
    'convert_is_already_type_Deposit'           => 'Bu işlem zaten bir para çekme işlemidir',
    'convert_is_already_type_Transfer'          => 'Bu işlem zaten bir transfer işlemidir',
    'convert_to_Withdrawal'                     => '":description" yı bir para çekme işlemine dönüştür',
    'convert_to_Deposit'                        => '":description" yı mevduata dönüştür',
    'convert_to_Transfer'                       => '":description" yı bir aktarıma dönüştür',
    'convert_options_WithdrawalDeposit'         => 'Para çekme işlemini çekime dönüştür',
    'convert_options_WithdrawalTransfer'        => 'Para çekim işlemini aktarmaya dönüştür',
    'convert_options_DepositTransfer'           => 'Para yatırma işlemini bir aktarmaya dönüştür',
    'convert_options_DepositWithdrawal'         => 'Para yatırma işlemini çekime dönüştür',
    'convert_options_TransferWithdrawal'        => 'Bir transferi çekime dönüştür',
    'convert_options_TransferDeposit'           => 'Bir transferi çekime dönüştür',
    'convert_Withdrawal_to_deposit'             => 'Bu para çekme işlemini para yatırma işlemine çevir',
    'convert_Withdrawal_to_transfer'            => 'Bu para çekim işlemini havaleye çevir',
    'convert_Deposit_to_withdrawal'             => 'Bu para yatırma işlemini para çekme işlemine dönüştür',
    'convert_Deposit_to_transfer'               => 'Bu yatırımı bir havale olarak değiştir',
    'convert_Transfer_to_deposit'               => 'Bu havaleyi birikime dönüştürün',
    'convert_Transfer_to_withdrawal'            => 'Bu transferi bir para çekme işlemine dönüştür',
    'convert_please_set_revenue_source'         => 'Lütfen paranın geleceği bir gelir hesabı seçiniz.',
    'convert_please_set_asset_destination'      => 'Lütfen paranın gideceği varlık hesabını seçin.',
    'convert_please_set_expense_destination'    => 'Lütfen paranın gideceği masraf hesaplarını seçin.',
    'convert_please_set_asset_source'           => 'Lütfen paranın geleceği bir varlık hesabı seçiniz.',
    'convert_expl_w_d'                          => 'Para çekme işleminden para yatırma işlemine dönüştürülürken, para çekilmek yerine görüntülenen hedef hesaba yatırılır./ Para çekme işleminden para yatırma işlemine dönüştürülürken, para onlardan çekilmek yerine görüntülenen hedef hesaplara yatırılır.',
    'convert_expl_w_t'                          => 'Para çekme işlemini aktarıma dönüştürürken, para orijinal gider hesabına harcanmak yerine kaynak hesaptan başka bir varlık veya yükümlülük hesabına aktarılır./ Para çekme işlemini aktarıma dönüştürürken, para orijinal gider hesaplarına harcanmak yerine kaynak hesaplardan diğer varlık veya yükümlülük hesaplarına aktarılır.',
    'convert_expl_d_w'                          => 'Para yatırma işlemini para çekme işlemine dönüştürürken, para yatırılmak yerine görüntülenen kaynak hesaptan çekilir./ Para yatırma işlemini para çekme işlemine dönüştürürken, para yatırılmak yerine görüntülenen kaynak hesaplardan çekilir.',
    'convert_expl_d_t'                          => 'Para yatırma işlemini aktarıma dönüştürdüğünüzde, para, varlık veya yükümlülük hesabınızdan herhangi birinden listelenen hedef hesaba yatırılır./ Bir depozitoyu aktarıma dönüştürdüğünüzde, para, varlık veya yükümlülük hesaplarınızdan herhangi birinden listelenen hedef hesaplara yatırılır.',
    'convert_expl_t_w'                          => 'Bir transferi para çekme işlemine dönüştürdüğünüzde, para transfer edilmek yerine burada belirlediğiniz hedef hesaba harcanacaktır./ Bir transferi para çekme işlemine dönüştürdüğünüzde, para transfer edilmek yerine burada belirlediğiniz hedef hesaplara harcanacaktır.',
    'convert_expl_t_d'                          => 'Bir havaleyi para yatırma işlemine dönüştürdüğünüzde, para buraya aktarılmak yerine burada gördüğünüz hedef hesaba yatırılır./ Bir havaleyi para yatırma işlemine dönüştürdüğünüzde, para transfer edilmek yerine burada gördüğünüz hedef hesaplara yatırılır.',
    'convert_select_sources'                    => 'Dönüşümü tamamlamak için lütfen aşağıdaki yeni kaynak hesabı ayarlayın./ Dönüşümü tamamlamak için lütfen aşağıdaki yeni kaynak hesaplarını ayarlayın.',
    'convert_select_destinations'               => 'Dönüşümü tamamlamak için lütfen aşağıdaki yeni hedef hesabı seçin./ Dönüşümü tamamlamak için lütfen aşağıdaki yeni hedef hesapları seçin.',
    'converted_to_Withdrawal'                   => 'İşlem çekime dönüştürüldü',
    'converted_to_Deposit'                      => 'İşlem depozitoya dönüştürüldü',
    'converted_to_Transfer'                     => 'İşlem aktarıma dönüştürüldü',
    'invalid_convert_selection'                 => 'Seçtiğiniz hesap zaten bu işlemde kullanılmış veya mevcut değil.',
    'source_or_dest_invalid'                    => 'Doğru işlem ayrıntıları bulunamıyor. Dönüşüm mümkün değildir.',
    'convert_to_withdrawal'                     => 'Para çekme işlemine dönüştür',
    'convert_to_deposit'                        => 'Depozitoya dönüştür',
    'convert_to_transfer'                       => 'Aktarıma dönüştür',

    // create new stuff:
    'create_new_withdrawal'                     => 'Yeni çekim oluştur',
    'create_new_deposit'                        => 'Yeni mevduat oluştur',
    'create_new_transfer'                       => 'Yeni transfer oluştur',
    'create_new_asset'                          => 'Yeni varlık hesabı oluştur',
    'create_new_liabilities'                    => 'Yeni sorumluluk oluşturma',
    'create_new_expense'                        => 'Yeni gider hesabı oluştur',
    'create_new_revenue'                        => 'Yeni gelir hesabı oluştur',
    'create_new_piggy_bank'                     => 'Yeni bir kumbara oluştur',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Yeni para birimi oluştur',
    'store_currency'                            => 'Yeni para birimini sakla',
    'update_currency'                           => 'Para birimini güncelle',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => ':name hala kullanıldığı için silinemiyor.',
    'cannot_delete_fallback_currency'           => ':name sistem geri dönüş para birimidir ve silinemez.',
    'cannot_disable_currency_journals'          => 'Devre dışı bırakılamıyor :name çünkü işlemler hala kullanıyor.',
    'cannot_disable_currency_last_left'         => 'Devre dışı bırakılamıyor :name çünkü en son etkinleştirilen para birimidir.',
    'cannot_disable_currency_account_meta'      => 'Devre dışı bırakılamıyor :name çünkü varlık hesaplarında kullanılır.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Devre dışı bırakılamıyor :name çünkü yinelenen işlemlerde kullanılır.',
    'cannot_disable_currency_available_budgets' => 'Devre dışı bırakılamıyor :name çünkü mevcut bütçelerde kullanılıyor.',
    'cannot_disable_currency_budget_limits'     => 'Devre dışı bırakılamıyor :name çünkü bütçe sınırlarında kullanılıyor.',
    'cannot_disable_currency_current_default'   => 'Devre dışı bırakılamıyor :name çünkü geçerli varsayılan para birimidir.',
    'cannot_disable_currency_system_fallback'   => 'Devre dışı bırakılamıyor :name çünkü sistem varsayılan para birimidir.',
    'disable_EUR_side_effects'                  => 'Euro, sistemin acil durum geri dönüş para birimidir. Devre dışı bırakmanın istenmeyen yan etkileri olabilir ve garantinizi geçersiz kılabilir.',
    'deleted_currency'                          => 'Para birimi :name silindi',
    'created_currency'                          => 'Para birimi :name oluşturuldu',
    'could_not_store_currency'                  => 'Yeni para birimi depolanamadı.',
    'updated_currency'                          => 'Para birimi :name güncellendi',
    'ask_site_owner'                            => 'Lütfen para birimleri eklemek, kaldırmak veya düzenlemek için :owner\'a danışın.',
    'currencies_intro'                          => 'Firefly III, burada ayarlayabileceğiniz ve etkinleştirebileceğiniz çeşitli para birimlerini destekliyor.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Varsayılanı yap',
    'default_currency'                          => 'varsayılan',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Engelli',
    'enable_currency'                           => 'Etkinleştirmek',
    'disable_currency'                          => 'Devre dışı bırakmak',
    'currencies_default_disabled'               => 'Most of these currencies are disabled by default. To use them, you must enable them first.',
    'currency_is_now_enabled'                   => 'Currency ":name" has been enabled',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Currency ":name" has been disabled',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Zorunlu alanlar',
    'optionalFields'                            => 'İsteğe bağlı alanlar',
    'options'                                   => 'Seçenekler',

    // budgets:
    'daily_budgets'                             => 'Daily budgets',
    'weekly_budgets'                            => 'Weekly budgets',
    'monthly_budgets'                           => 'Monthly budgets',
    'quarterly_budgets'                         => 'Quarterly budgets',
    'half_year_budgets'                         => 'Half-yearly budgets',
    'yearly_budgets'                            => 'Yearly budgets',
    'other_budgets'                             => 'Custom timed budgets',
    'budget_limit_not_in_range'                 => 'This amount applies from :start to :end:',
    'total_available_budget'                    => 'Total available budget (between :start and :end)',
    'total_available_budget_in_currency'        => 'Total available budget in :currency',
    'see_below'                                 => 'see below',
    'create_new_budget'                         => 'Yeni bir bütçe oluştur',
    'store_new_budget'                          => 'Yeni bütçeyi sakla',
    'stored_new_budget'                         => 'Yeni bütçe ":name" kaydedildi',
    'available_between'                         => ':start ve :end arasında kullanılabilir',
    'transactionsWithoutBudget'                 => 'Bütçesiz Giderler',
    'transactions_no_budget'                    => ':start ve :end arasındaki bütçe dışı harcamalar',
    'spent_between'                             => 'Already spent between :start and :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Set available amount',
    'update_available_amount'                   => 'Update available amount',
    'ab_basic_modal_explain'                    => 'Use this form to indicate how much you expect to be able to budget (in total, in :currency) in the indicated period.',
    'createBudget'                              => 'Yeni bütçe',
    'invalid_currency'                          => 'This is an invalid currency',
    'invalid_amount'                            => 'Please enter an amount',
    'set_ab'                                    => 'The available budget amount has been set',
    'updated_ab'                                => 'The available budget amount has been updated',
    'deleted_ab'                                => 'The available budget amount has been deleted',
    'deleted_bl'                                => 'The budgeted amount has been removed',
    'alt_currency_ab_create'                    => 'Set the available budget in another currency',
    'bl_create_btn'                             => 'Set budget in another currency',
    'inactiveBudgets'                           => 'Etkin olmayan bütçeler',
    'without_budget_between'                    => ':start ve :end arasında bütçesiz işlemler',
    'delete_budget'                             => '":name" bütçesini sil',
    'deleted_budget'                            => 'Silinen bütçe ":name"',
    'edit_budget'                               => '":name" bütçesini düzenle',
    'updated_budget'                            => 'Güncellenmiş bütçe ":name"',
    'update_amount'                             => 'Güncelleme miktarı',
    'update_budget'                             => 'Bütçeyi güncelle',
    'update_budget_amount_range'                => ':start ve :end arasında (beklenen) mevcut miktarı güncelleyiniz',
    'set_budget_limit_title'                    => 'Set budgeted amount for budget :budget between :start and :end',
    'set_budget_limit'                          => 'Set budgeted amount',
    'budget_period_navigator'                   => 'Devreden sayacı',
    'info_on_available_amount'                  => 'Elimde ne var?',
    'available_amount_indication'               => 'Toplam bütçenizin ne olabileceğinin bir göstergesi olarak bu tutarı kullanın.',
    'suggested'                                 => 'Önerilen',
    'average_between'                           => ':start ve :end arasında Averaj',
    'transferred_in'                            => 'Transferred (in)',
    'transferred_away'                          => 'Transferred (away)',
    'auto_budget_none'                          => 'No auto-budget',
    'auto_budget_reset'                         => 'Set a fixed amount every period',
    'auto_budget_rollover'                      => 'Add an amount every period',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Günlük',
    'auto_budget_period_weekly'                 => 'Haftalık',
    'auto_budget_period_monthly'                => 'Aylık',
    'auto_budget_period_quarterly'              => 'Üç aylık',
    'auto_budget_period_half_year'              => 'Her yarım yılda bir',
    'auto_budget_period_yearly'                 => 'Yıllık',
    'auto_budget_help'                          => 'Bu özellik hakkında daha fazla bilgiyi yardım\'da okuyabilirsiniz. Sağ üst köşedeki sembolu (?) tıklayın.',
    'auto_budget_reset_icon'                    => 'Bu bütçe periyodik olarak belirlenecektir',
    'auto_budget_rollover_icon'                 => 'Bütçe tutarı periyodik olarak artacaktır',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Bütçelenmiş tutarı kaldır :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Bu süre beklenmiyor',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '(Henüz)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Tekrarlar',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'İlişkili işlemler',
    'auto_match_on'                             => 'Firefly III tarafından otomatik olarak eşleştirildi',
    'auto_match_off'                            => 'Firefly III tarafından otomatik olarak eşleşmiyor',
    'next_expected_match'                       => 'Beklenen sonraki eşleşme',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Daha',
    'rescan_old'                                => 'Tüm işlemlerde kuralları yeniden çalıştırın',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => ':start ve :end arasında beklenen',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'atla',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'Etkin Olmayan Kurallar',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Beklenen :date',
    'bill_expected_date_js'                     => 'Beklenen {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Ödeme Tarihi {date}',
    'bill_repeats_weekly'                       => 'Haftalık tekrarlar',
    'bill_repeats_monthly'                      => 'Aylık tekrarlar',
    'bill_repeats_quarterly'                    => 'Üç ayda bir tekrarlar',
    'bill_repeats_half-year'                    => 'Her yarım yılda bir tekrarlar',
    'bill_repeats_yearly'                       => 'Yıllık tekrarlar',
    'bill_repeats_weekly_other'                 => 'Her hafta tekrarlar',
    'bill_repeats_monthly_other'                => 'Her ay tekrarlar',
    'bill_repeats_quarterly_other'              => 'Her çeyrekte tekrarlar',
    'bill_repeats_half-year_other'              => 'Yıllık tekrarlar',
    'bill_repeats_yearly_other'                 => 'Her yıl tekrarlar',
    'bill_repeats_weekly_skip'                  => 'Her birini tekrarlar {skip} haftalar',
    'bill_repeats_monthly_skip'                 => 'Her {skip} ayda bir tekrarlar',
    'bill_repeats_quarterly_skip'               => 'Her{skip} çeyreğini tekrarlar',
    'bill_repeats_half-year_skip'               => 'Her {skip} yarım yılda bir tekrarlar',
    'bill_repeats_yearly_skip'                  => 'Her {skip} yılda bir tekrarlar',
    'subscriptions'                             => 'Abonelik',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Sonsuza dek',
    'extension_date_is'                         => 'Uzantı tarihi {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Sahipsin :count bu ayrı sayfada görüntüleyebileceğiniz etkin olmayan (arşivlenmiş) hesap.|Sahipsin:count inactive (archived) accounts, which you can view on this separate page.Bu ayrı sayfada görüntüleyebileceğiniz etkin olmayan (arşivlenmiş) hesaplar.',
    'all_accounts_inactive'                     => 'Bunlar aktif olmayan hesaplarınız.',
    'active_account_link'                       => 'Bu bağlantı etkin hesaplarınıza geri döner.',
    'account_missing_transaction'               => 'Hesap #: ıd (": name") doğrudan görüntülenemiyor, ancak Firefly yönlendirme bilgileri eksik.',
    'cc_monthly_payment_date_help'              => 'Herhangi bir yılı ve herhangi bir ayı seçin, yine de göz ardı edilecektir. Sadece ayın günü geçerlidir.',
    'details_for_asset'                         => '":name" Varlık hesabı ayrıntıları',
    'details_for_expense'                       => '":name" Harcama hesabı ayrıntıları',
    'details_for_revenue'                       => '":name" Gelir hesabı ayrıntıları',
    'details_for_cash'                          => '":name" Nakit hesabı ayrıntıları',
    'store_new_asset_account'                   => 'Yeni varlık hesabını kaydet',
    'store_new_expense_account'                 => 'Yeni gider hesabını sakla',
    'store_new_revenue_account'                 => 'Yeni gelir hesabını kaydet',
    'edit_asset_account'                        => '":name" Öğe hesabını düzenle',
    'edit_expense_account'                      => '":name" Harcama hesabını düzenle',
    'edit_revenue_account'                      => '":name" Gelir hesabını düzenle',
    'delete_asset_account'                      => '":name" Öğe hesabını sil',
    'delete_expense_account'                    => '":name" Masraf hesaplarını sil',
    'delete_revenue_account'                    => '":name" Gelir hesabını sil',
    'delete_liabilities_account'                => 'Sorumluluğu sil:name',
    'asset_deleted'                             => '":name" Adlı varlık hesabı başarıyla silindi',
    'account_deleted'                           => ':name hesabı başarıyla silindi',
    'expense_deleted'                           => '":name" gider hesabı başarıyla silindi',
    'revenue_deleted'                           => '":name" gelir hesabı başarıyla silindi',
    'update_asset_account'                      => 'Varlık hesabını güncelle',
    'update_undefined_account'                  => 'Hesabı güncelle',
    'update_liabilities_account'                => 'Güncelleme sorumluluğu',
    'update_expense_account'                    => 'Gider hesabını güncelle',
    'update_revenue_account'                    => 'Gelir hesabı güncelleme',
    'make_new_asset_account'                    => 'Yeni varlık hesabı oluştur',
    'make_new_expense_account'                  => 'Yeni gider hesabı oluştur',
    'make_new_revenue_account'                  => 'Yeni gelir hesabı oluştur',
    'make_new_liabilities_account'              => 'Create a new liability',
    'asset_accounts'                            => 'Varlık hesapları',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Asset accounts (inactive)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Gider hesapları',
    'expense_accounts_inactive'                 => 'Expense accounts (inactive)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Gelir hesapları',
    'revenue_accounts_inactive'                 => 'Revenue accounts (inactive)',
    'cash_accounts'                             => 'Nakit Hesabı',
    'Cash account'                              => 'Nakit Hesabı',
    'liabilities_accounts'                      => 'Liabilities',
    'liabilities_accounts_inactive'             => 'Liabilities (inactive)',
    'reconcile_account'                         => 'Hesabı ":account" dengeleyin',
    'overview_of_reconcile_modal'               => 'Overview of reconciliation',
    'delete_reconciliation'                     => 'Mutabakatı sil',
    'update_reconciliation'                     => 'Mutabakatı güncelle',
    'amount_cannot_be_zero'                     => 'Miktar sıfır olamaz',
    'end_of_reconcile_period'                   => 'Uzlaştırma dönemi sonu: :period',
    'start_of_reconcile_period'                 => 'Uzlaştırma dönemi başlangıcı: :period',
    'start_balance'                             => 'Başlangıç bakiyesi',
    'end_balance'                               => 'Son bakiye',
    'update_balance_dates_instruction'          => 'Yukarıdaki tutarlar ve tarihleri banka ekstrenizle esşleştirin ve "Mutabakatı başlat" düğmesine basın',
    'select_transactions_instruction'           => 'Banka ekstrenizde görünen işlemleri seçin.',
    'select_range_and_balance'                  => 'Önce tarih aralığını ve bakiyeleri doğrulayın. Daha sonra "Mutabakatı başlat" tuşuna basın',
    'date_change_instruction'                   => 'Tarih aralığını şim değiştirdiniz, ilerleme kaydedilemez.',
    'update_selection'                          => 'Güncelleme seç',
    'store_reconcile'                           => 'Mutabakatı sakla',
    'reconciliation_transaction'                => 'Mutabakat işlemi',
    'Reconciliation'                            => 'Mutabakat',
    'reconciliation'                            => 'Mutabakat',
    'reconcile_options'                         => 'Mutabakat Seçenekleri',
    'reconcile_range'                           => 'Mutabakat aralığı',
    'start_reconcile'                           => 'Mutabakatı başlat',
    'cash_account_type'                         => 'Cash',
    'cash'                                      => 'nakit',
    'cant_find_redirect_account'                => 'Firefly III tried to redirect you but couldn\'t. Sorry about that. Back to the index.',
    'account_type'                              => 'Hesap Türü',
    'save_transactions_by_moving'               => 'Save this transaction by moving it to another account:|Save these transactions by moving them to another account:',
    'save_transactions_by_moving_js'            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                        => 'Yeni hesap ":name" kaydedildi!',
    'stored_new_account_js'                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                           => 'Güncellenmiş hesap ismi ":name"',
    'updated_account_js'                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Kredi kart seçenekleri',
    'no_transactions_account'                   => 'Aktif hesapta herhangi bir işlem yok (bu dönem için) ":name".',
    'no_transactions_period'                    => 'There are no transactions (in this period).',
    'no_data_for_chart'                         => 'Bu grafiği oluşturmak için yeterli bilgi (henüz) yok.',
    'select_at_least_one_account'               => 'Please select at least one asset account',
    'select_at_least_one_category'              => 'Please select at least one category',
    'select_at_least_one_budget'                => 'Please select at least one budget',
    'select_at_least_one_tag'                   => 'Please select at least one tag',
    'select_at_least_one_expense'               => 'Please select at least one combination of expense/revenue accounts. If you have none (the list is empty) this report is not available.',
    'account_default_currency'                  => 'This will be the default currency associated with this account.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Firefly III hesabınızda bankanızın iddia ettiğinden daha fazla para var. Birkaç seçenek var. Lütfen ne yapılacağını seçin. Daha sonra "Uzlaşmayı onayla" ya basın.',
    'reconcile_has_less'                        => 'Firefly III\'de bankanızın iddia ettiğinden daha az para var. Birkaç seçenek var. Lütfen ne yapılacağını seçin. Daha sonra "Uzlaşmayı onayla"\'ya basın.',
    'reconcile_is_equal'                        => 'Firefly III hesabınızdaki para ile banka ekstreniz eşleşiyor. Yapılacak bir şey yok. Lütfen girdinizi onaylamak için "Uzlaşmayı onayla"\'ya basın.',
    'create_pos_reconcile_transaction'          => 'Seçilen işlemleri temizleyiniz ve varlık hesabına :amount ekleyerek bir düzeltme oluşturun.',
    'create_neg_reconcile_transaction'          => 'Seçilen işlemleri temizleyiniz ve varlık hesabından :amount kaldırarak bir düzeltme oluşturun.',
    'reconcile_do_nothing'                      => 'Seçilen işlemleri temizleyin, ama düzeltmeyiniz.',
    'reconcile_go_back'                         => 'Bir düzeltmeyi daha sonra her zaman düzenleyebilir ya da silebilirsiniz.',
    'must_be_asset_account'                     => 'Sadece varlık hesapları bağdaştırabilirsiniz',
    'reconciliation_stored'                     => 'Depolanmış Mutabakat',
    'reconciliation_error'                      => 'Due to an error the transactions were marked as reconciled but the correction has not been stored: :error.',
    'reconciliation_transaction_title'          => 'Reconciliation (:from to :to)',
    'sum_of_reconciliation'                     => 'Sum of reconciliation',
    'reconcile_this_account'                    => 'Bu hesabı bağdaştırınız',
    'reconcile'                                 => 'Reconcile',
    'show'                                      => 'Show',
    'confirm_reconciliation'                    => 'Mutabakatı onayla',
    'submitted_start_balance'                   => 'Gönderilen başlangıç bakiyesi',
    'selected_transactions'                     => 'Seçilen İşlemler (:count)',
    'already_cleared_transactions'              => 'Halihazırda temizlenmiş işlemler (:count)',
    'submitted_end_balance'                     => 'Gönderilen bitiş bakiyesi',
    'initial_balance_description'               => 'Initial balance for ":account"',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'unknown',
    'interest_calc_daily'                       => 'Per day',
    'interest_calc_monthly'                     => 'Per month',
    'interest_calc_yearly'                      => 'Per year',
    'interest_calc_weekly'                      => 'Per week',
    'interest_calc_half-year'                   => 'Per half year',
    'interest_calc_quarterly'                   => 'Per quarter',
    'initial_balance_account'                   => 'Initial balance account of :account',
    'list_options'                              => 'List options',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Yeni Kategori',
    'create_new_category'                       => 'Yeni bir kategori oluştur',
    'without_category'                          => 'Kategori olmaksızın',
    'update_category'                           => 'Kategoriyi güncelle',
    'updated_category'                          => '":name" kategorisi güncellendi',
    'categories'                                => 'Kategoriler',
    'edit_category'                             => '":name" kategorisini düzenle',
    'no_category'                               => '(Kategori yok)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategori',
    'delete_category'                           => '":name" kategorisini sil',
    'deleted_category'                          => '  kategorisi silindi',
    'store_category'                            => 'Yeni kategoriyi kaydet',
    'stored_category'                           => 'Kaydedilen yeni kategori ":name"',
    'without_category_between'                  => ':start ve :end arasında kategorisiz',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Geri çekmeyi güncelle',
    'update_deposit'                            => 'Depozitoyu güncelle',
    'update_transaction'                        => 'Update transaction',
    'update_transfer'                           => 'Aktarımı güncelle',
    'updated_withdrawal'                        => 'Para çekme güncellendi ":description"',
    'updated_deposit'                           => 'Güncellenmiş depozito ":description"',
    'updated_transfer'                          => 'Güncellenmiş ":description"',
    'no_changes_withdrawal'                     => 'Withdrawal ":description" was not changed.',
    'no_changes_deposit'                        => 'Deposit ":description" was not changed.',
    'no_changes_transfer'                       => 'Transfer ":description" was not changed.',
    'delete_withdrawal'                         => 'Çekimi sil ":description"',
    'delete_deposit'                            => 'Mevduat sil ":description"',
    'delete_transfer'                           => 'Aktarımı sil ":description"',
    'deleted_withdrawal'                        => 'Çekilme başarıyla silindi ":description"',
    'deleted_deposit'                           => '":description" Para yatırma başarıyla silindi',
    'deleted_transfer'                          => '":description" Aktarım başarıyla silindi',
    'deleted_reconciliation'                    => 'Successfully deleted reconciliation transaction ":description"',
    'stored_journal'                            => '":description" Yeni işlem başarıyla oluşturuldu',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Successfully created your new transaction',
    'updated_journal_no_descr'                  => 'Successfully updated your transaction',
    'select_transactions'                       => 'İşlemleri Seç',
    'rule_group_select_transactions'            => 'İşlemlere "başlık" uygula',
    'rule_select_transactions'                  => 'İşlemlere "başlık" uygula',
    'stop_selection'                            => 'İşlemleri seçmeyi durdur',
    'reconcile_selected'                        => 'Onaylanmış',
    'mass_delete_journals'                      => 'Bir dizi işlemi sil',
    'mass_edit_journals'                        => 'Bir dizi işlem düzenle',
    'mass_bulk_journals'                        => 'Bulk edit a number of transactions',
    'mass_bulk_journals_explain'                => 'This form allows you to change properties of the transactions listed below in one sweeping update. All the transactions in the table will be updated when you change the parameters you see here.',
    'part_of_split'                             => 'This transaction is part of a split transaction. If you have not selected all the splits, you may end up with changing only half the transaction.',
    'bulk_set_new_values'                       => 'Use the inputs below to set new values. If you leave them empty, they will be made empty for all. Also, note that only withdrawals will be given a budget.',
    'no_bulk_category'                          => 'Don\'t update category',
    'no_bulk_budget'                            => 'Don\'t update budget',
    'no_bulk_tags'                              => 'Etiket (ler) i güncelleme',
    'replace_with_these_tags'                   => 'Bu etiketlerle değiştirin',
    'append_these_tags'                         => 'Bu etiketleri ekle',
    'mass_edit'                                 => 'Seçilenleri tek tek düzenle',
    'bulk_edit'                                 => 'Toplu olarak seçilenleri düzenle',
    'mass_delete'                               => 'Seçileni sil',
    'cannot_edit_other_fields'                  => 'Gösterecek yer olmadığı için, bu dosya dışındaki dosyaları toplu olarak düzenleyemezsiniz. Eğer o alanları düzenlemeniz gerekliyse lütfen linki takip edin ve onları teker teker düzenleyin.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(bütçe yok)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Bütçe başına hesap',
    'account_per_category'                      => 'Kategori başına hesap',
    'create_new_object'                         => 'Yaratmak',
    'empty'                                     => '(boş)',
    'all_other_budgets'                         => '(diğer tüm bütçeler)',
    'all_other_accounts'                        => '(diğer tüm hesaplar)',
    'expense_per_source_account'                => 'Kaynak hesap başına giderler',
    'expense_per_destination_account'           => 'Hedef hesap başına giderler',
    'income_per_destination_account'            => 'Hedef hesap başına gelir',
    'spent_in_specific_category'                => ':category kategorisinde harcandı',
    'earned_in_specific_category'               => ':category kategorisinde kazanılan',
    'spent_in_specific_tag'                     => 'Etikette harcanan:tag',
    'earned_in_specific_tag'                    => ':tag etiketinde kazanıldı',
    'income_per_source_account'                 => 'Kaynak hesap başına gelir',
    'average_spending_per_destination'          => 'Hedef hesap başına ortalama gider',
    'average_spending_per_source'               => 'Kaynak hesap başına ortalama gider',
    'average_earning_per_source'                => 'Kaynak hesap başına ortalama kazanç',
    'average_earning_per_destination'           => 'Hedef hesap başına ortalama kazanç',
    'account_per_tag'                           => 'Etiket başına hesap',
    'tag_report_expenses_listed_once'           => 'Giderler ve gelirler asla iki kez listelenmez. Bir işlemin birden çok etiketi varsa, yalnızca etiketlerinden birinin altında görünebilir. Bu liste eksik veri gibi görünebilir, ancak tutarlar doğru olacaktır.',
    'double_report_expenses_charted_once'       => 'Giderler ve gelirler hiçbir zaman iki kez görüntülenmez. Bir işlemin birden çok etiketi varsa, yalnızca etiketlerinden birinin altında görünebilir. Bu grafikte veri eksik gibi görünebilir, ancak tutarlar doğru olacaktır.',
    'tag_report_chart_single_tag'               => 'Bu grafik tek bir etiket için geçerlidir. Bir işlemin birden çok etiketi varsa, burada gördükleriniz diğer etiketlerin grafiklerine de yansıtılabilir.',
    'tag'                                       => 'Etiket',
    'no_budget_squared'                         => '(Bütçe yok)',
    'perm-delete-many'                          => 'Bir seferde birçok öğeyi silmek çok yıkıcı olabilir. Lütfen dikkatli olun. Bölünmüş bir işlemin bir bölümünü bu sayfadan silebilirsiniz, bu nedenle dikkatli olun.',
    'mass_deleted_transactions_success'         => 'Silmek :count işlem.|Silmek :count işlemler.',
    'mass_edited_transactions_success'          => 'Updated :count işlem.|Silmek :count işlemler.',
    'opt_group_'                                => '(hesap türü yok)',
    'opt_group_no_account_type'                 => '(hesap türü yok)',
    'opt_group_defaultAsset'                    => 'Varsayılan varlık hesapları',
    'opt_group_savingAsset'                     => 'Tasarruf Hesapları',
    'opt_group_sharedAsset'                     => 'Paylaşılan varlık hesapları',
    'opt_group_ccAsset'                         => 'Kredi Kartı',
    'opt_group_cashWalletAsset'                 => 'Nakit cüzdan',
    'opt_group_expense_account'                 => 'Gider hesapları',
    'opt_group_revenue_account'                 => 'Gelir hesapları',
    'opt_group_l_Loan'                          => 'Sorumluluk: Kredi',
    'opt_group_cash_account'                    => 'Nakit hesabı',
    'opt_group_l_Debt'                          => 'Sorumluluk: Borç',
    'opt_group_l_Mortgage'                      => 'Sorumluluk: İpotek',
    'opt_group_l_Credit card'                   => 'Sorumluluk: Kredi kartı',
    'notes'                                     => 'Notlar',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'İşlem depolanamadı. Lütfen günlük dosyalarını kontrol edin.',
    'attachment_not_found'                      => 'Bu ek bulunamadı.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">İşlem #{ID} ("{title}")</a> saklı olmuştur.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">İşlem #{ID}</a>saklı olmuştur.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                   => 'Firefly III\'e hoşgeldiniz!',
    'submit'                                    => 'Gönder',
    'submission'                                => 'Submission',
    'submit_yes_really'                         => 'Submit (I know what I\'m doing)',
    'getting_started'                           => 'Başla',
    'to_get_started'                            => 'Firefly III\'ü başarılı şekilde yüklediğinizi görmek güzel. Bu aracı kullanmak için lütfen banka adınızı ve ana hesabınızın bakiyesini girin. Birden fazla hesabınız varsa endişelenmeyin. Onları daha sonra ekleyebilirsiniz. Bu adım sadece Firefly III\'ün bir yerden başlaması gerektiği içindir.',
    'savings_balance_text'                      => 'Firefly III sizin için otomatik olarak bir birikim hesabı oluşturacaktır. Varsayılan olarak birikim hesabınızda hiç para olmayacaktır ama Firefly III\'e dengelemesini söylerseniz o şekilde saklayacaktır.',
    'finish_up_new_user'                        => 'İşte bu! <strong>Submit</strong> tıklayarak devam edebilirsiniz. Firefly III Anasayfasına yönlendirileceksiniz.',
    'stored_new_accounts_new_user'              => 'Yuppi! Yeni hesabınız kaydedildi.',
    'set_preferred_language'                    => 'If you prefer to use Firefly III in another language, please indicate so here.',
    'language'                                  => 'Dil',
    'new_savings_account'                       => ':bank_name tasarruf hesabı',
    'cash_wallet'                               => 'Nakit cüzdan',
    'currency_not_present'                      => 'Normalde kullandığınız para birimi listelenmiyorsa endişelenmeyin. Seçenekler> Para Birimleri altında kendi para birimlerini oluşturabilirsiniz.',

    // home page:
    'transaction_table_description'             => 'A table containing your transactions',
    'opposing_account'                          => 'Opposing account',
    'yourAccounts'                              => 'Hesaplarınız',
    'your_accounts'                             => 'Your account overview',
    'category_overview'                         => 'Category overview',
    'expense_overview'                          => 'Expense account overview',
    'revenue_overview'                          => 'Revenue account overview',
    'budgetsAndSpending'                        => 'Bütçe ve Harcama',
    'budgets_and_spending'                      => 'Budgets and spending',
    'go_to_budget'                              => 'Go to budget "{budget}"',
    'go_to_deposits'                            => 'Go to deposits',
    'go_to_expenses'                            => 'Go to expenses',
    'savings'                                   => 'Birikim',
    'newWithdrawal'                             => 'Yeni gider',
    'newDeposit'                                => 'Yeni mevduat',
    'newTransfer'                               => 'Yeni Transfer',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Hergün',
    'left_to_spend_per_day'                     => 'Günlük harcama için bırakıldı',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Custom period',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Select a period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Para birimi',
    'preferences'                               => 'Tercihler',
    'logout'                                    => 'Çıkış Yap',
    'logout_other_sessions'                     => 'Logout all other sessions',
    'toggleNavigation'                          => 'Navigasyonu aç / kapat',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Aranıyor...',
    'version'                                   => 'Versiyon',
    'dashboard'                                 => 'Gösterge paneli',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Available budget ({currency})',
    'currencies'                                => 'Kurlar',
    'activity'                                  => 'Activity',
    'usage'                                     => 'Usage',
    'accounts'                                  => 'Hesaplar',
    'Asset account'                             => 'Varlık hesabı',
    'Default account'                           => 'Varlık hesabı',
    'Expense account'                           => 'Gider hesabı',
    'Revenue account'                           => 'Gelir hesabı',
    'Initial balance account'                   => 'Başlangıç bakiye hesabı',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Debt',
    'account_type_Loan'                         => 'Loan',
    'account_type_Mortgage'                     => 'Mortgage',
    'account_type_debt'                         => 'Debt',
    'account_type_loan'                         => 'Loan',
    'account_type_mortgage'                     => 'Mortgage',
    'account_type_Credit card'                  => 'Credit card',
    'credit_card_type_monthlyFull'              => 'Full payment every month',
    'liability_direction_credit'                => 'I am owed this debt',
    'liability_direction_debit'                 => 'I owe this debt to somebody else',
    'liability_direction_credit_short'          => 'Owed this debt',
    'liability_direction_debit_short'           => 'Owe this debt',
    'liability_direction__short'                => 'Unknown',
    'liability_direction_null_short'            => 'Unknown',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Bütçeler',
    'tags'                                      => 'Etiketler',
    'reports'                                   => 'Raporlar',
    'transactions'                              => 'İşlemler',
    'expenses'                                  => 'Giderler',
    'income'                                    => 'Gelir / gelir',
    'transfers'                                 => 'Transferler',
    'moneyManagement'                           => 'Para Yönetimi',
    'money_management'                          => 'Money management',
    'tools'                                     => 'Tools',
    'piggyBanks'                                => 'Kumbara',
    'piggy_banks'                               => 'Piggy banks',
    'amount_x_of_y'                             => '{current} of {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Para Çekme',
    'opening_balance'                           => 'Açılış bakiyesi',
    'deposit'                                   => 'Mevduat',
    'account'                                   => 'Hesap',
    'transfer'                                  => 'Havale',
    'Withdrawal'                                => 'Para Çekme',
    'Deposit'                                   => 'Mevduat',
    'Transfer'                                  => 'Havale',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Evet',
    'no'                                        => 'Hayır',
    'amount'                                    => 'Miktar',
    'overview'                                  => 'Genel Bakış',
    'saveOnAccount'                             => 'Hesabı Kaydet',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Bilinmeyen',
    'monthly'                                   => 'Aylık',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Hatalar',
    'debt_start_date'                           => 'Start date of debt',
    'debt_start_amount'                         => 'Start amount of debt',
    'debt_start_amount_help'                    => 'It\'s always best to set this value to a negative amount. Read the help pages (top right (?)-icon) for more information.',
    'interest_period_help'                      => 'This field is purely cosmetic and won\'t be calculated for you. As it turns out banks are very sneaky so Firefly III never gets it right.',
    'store_new_liabilities_account'             => 'Store new liability',
    'edit_liabilities_account'                  => 'Edit liability ":name"',
    'financial_control'                         => 'Financial control',
    'accounting'                                => 'Accounting',
    'automation'                                => 'Automation',
    'others'                                    => 'Others',
    'classification'                            => 'Classification',
    'store_transaction'                         => 'Store transaction',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => ':start ve :end arasında varsayılan finans raporu',
    'report_audit'                              => ':start ve :end arasında işlem geçmişine genel bakış',
    'report_category'                           => ':start ve :end arasında kategori raporu',
    'report_double'                             => 'Expense/revenue account report between :start and :end',
    'report_budget'                             => ':start ve :end arasında bütçe raporu',
    'report_tag'                                => ':start ve :end arasında etiket raporu',
    'quick_link_reports'                        => 'Hızlı Erişim',
    'quick_link_examples'                       => 'These are just some example links to get you started. Check out the help pages under the (?)-button for information on all reports and the magic words you can use.',
    'quick_link_default_report'                 => 'Varsayılan finansal rapor',
    'quick_link_audit_report'                   => 'İşlem geçmişine genel bakış',
    'report_this_month_quick'                   => 'Cari ay, tüm hesaplar',
    'report_last_month_quick'                   => 'Last month, all accounts',
    'report_this_year_quick'                    => 'Cari yıl, tüm hesaplar',
    'report_this_fiscal_year_quick'             => 'Cari mali yıl, bütün hesaplar',
    'report_all_time_quick'                     => 'Bütün zaman, bütün hesaplar',
    'reports_can_bookmark'                      => 'Raporların yer imlerine eklenebileceğini unutmayın.',
    'incomeVsExpenses'                          => 'Gelir ve giderler',
    'accountBalances'                           => 'Hesap bakiyeleri',
    'balanceStart'                              => 'Dönem Başında Bakiye',
    'balanceEnd'                                => 'Dönem Sonunda Bakiye',
    'splitByAccount'                            => 'Hesaplara göre bölünmüş',
    'coveredWithTags'                           => 'Etiketler kapatılmıştır',
    'leftInBudget'                              => 'Bütçede bırakıldı',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Hesap toplamı',
    'noCategory'                                => '(Kategori yok)',
    'notCharged'                                => 'Ücret alınmadı (henüz)',
    'inactive'                                  => 'Etkisiz',
    'active'                                    => 'Aktif',
    'difference'                                => 'Fark',
    'money_flowing_in'                          => 'İçeri',
    'money_flowing_out'                         => 'Dışarı',
    'topX'                                      => 'üst :number',
    'show_full_list'                            => 'Tüm listeyi göster',
    'show_only_top'                             => 'Sadece üst :number göster',
    'report_type'                               => 'Rapor Türü',
    'report_type_default'                       => 'Varsayılan finansal rapor',
    'report_type_audit'                         => 'İşlem geçmişine genel bakış (denetim)',
    'report_type_category'                      => 'Kategori raporu',
    'report_type_budget'                        => 'Bütçe raporu',
    'report_type_tag'                           => 'Etiket raporu',
    'report_type_double'                        => 'Expense/revenue account report',
    'more_info_help'                            => 'Bu tür raporlar hakkında daha fazla bilgi yardım sayfalarında bulunabilir. Sağ üst köşedeki (?) simgesine basın.',
    'report_included_accounts'                  => 'Dahil edilen hesaplar',
    'report_date_range'                         => 'Tarih aralığı',
    'report_preset_ranges'                      => 'Önceden ayarlanmış aralıklar',
    'shared'                                    => 'Paylaşılan',
    'fiscal_year'                               => 'Mali yıl',
    'income_entry'                              => ':start ve :end arasında ":name" hesabının geliri',
    'expense_entry'                             => ':start ve :end arasında ":name" hesabının giderleri',
    'category_entry'                            => 'Expenses and income in category ":name" between :start and :end',
    'budget_spent_amount'                       => '":budget" bütçesindeki :start ve :end arası harcamalar',
    'balance_amount'                            => '":budget" bütçesindeki, ":account" hesabından :start ve :end arası ödenen giderler',
    'no_audit_activity'                         => '<a href=":url" title=":account_name">:account_name</a> hesabında :start ve :end arasında hiç bir hareket kaydedilmedi.',
    'audit_end_balance'                         => ':end sonunda <a href=":url" title=":account_name">:account_name</a> hesabının bakiyesi: :balance',
    'reports_extra_options'                     => 'Ekstra Seçenekler',
    'report_has_no_extra_options'               => 'Bu raporda ekstra bir seçenek yok',
    'reports_submit'                            => 'Raporu görüntüle',
    'end_after_start_date'                      => 'Raporun bitiş tarihi, başlangıç tarihinden sonra olmalıdır.',
    'select_category'                           => 'Kategori (ler) seçin',
    'select_budget'                             => 'Bütçe (ler) seçin.',
    'select_tag'                                => 'Etiket (ler) seçin.',
    'income_per_category'                       => 'Kategori başına gelir',
    'expense_per_category'                      => 'Kategori başına harcama',
    'expense_per_budget'                        => 'Bütçe başına harcama',
    'income_per_account'                        => 'Hesap başına gelir',
    'expense_per_account'                       => 'Hesap başına gider',
    'expense_per_tag'                           => 'Etiket başına harcama',
    'income_per_tag'                            => 'Etiket başına gelir',
    'include_expense_not_in_budget'             => 'Dahil edilen masraflar seçili bütçe(ler) içinde değil',
    'include_expense_not_in_account'            => 'Dahil edilen masraflar seçili hesaplar(lar) içinde değil',
    'include_expense_not_in_category'           => 'Dahil edilen masraflar seçili kategori(ler) içinde değil',
    'include_income_not_in_category'            => 'Dahil edilen gelirler seçili kategori(ler) içinde değil',
    'include_income_not_in_account'             => 'Dahil edilen gelirler seçili hesap(lar) içinde değil',
    'include_income_not_in_tags'                => 'Dahil edilen gelirler seçili etiket(ler) içinde değil',
    'include_expense_not_in_tags'               => 'Dahil edilen giderler seçili etiket(ler) içinde değil',
    'everything_else'                           => 'Geri kalan her şey',
    'income_and_expenses'                       => 'Gelir ve gider',
    'spent_average'                             => 'Harcanan (ortalama)',
    'income_average'                            => 'Gelir (ortalama)',
    'transaction_count'                         => 'İşlem sayısı',
    'average_spending_per_account'              => 'Hesap başına ortalama harcama',
    'average_income_per_account'                => 'Hesap başına ortalama gelir',
    'total'                                     => 'Genel Toplam',
    'description'                               => 'Açıklama',
    'sum_of_period'                             => 'Dönemin toplamı',
    'average_in_period'                         => 'Dönem içinde ortalama',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Varsayılan varlık hesabı',
    'account_role_sharedAsset'                  => 'Paylaşılan varlık hesabı',
    'account_role_savingAsset'                  => 'Birikim hesabı',
    'account_role_ccAsset'                      => 'Kredi Kartı',
    'account_role_cashWalletAsset'              => 'Nakit cüzdan',
    'budget_chart_click'                        => 'Bir grafik görmek için lütfen yukarıdaki tabloda bir bütçe adına tıklayın.',
    'category_chart_click'                      => 'Bir grafik görmek için lütfen yukarıdaki tabloda bir kategori adına tıklayın.',
    'in_out_accounts'                           => 'Kazanılan ve kombinasyon başına harcanan',
    'in_out_accounts_per_asset'                 => 'Earned and spent (per asset account)',
    'in_out_per_category'                       => 'Kazanılan ve kategori başına harcanan',
    'out_per_budget'                            => 'Bütçe başına harcama',
    'select_expense_revenue'                    => 'Harcama / gelir hesabı seçin',
    'multi_currency_report_sum'                 => 'Because this list contains accounts with multiple currencies, the sum(s) you see may not make sense. The report will always fall back to your default currency.',
    'sum_in_default_currency'                   => 'The sum will always be in your default currency.',
    'net_filtered_prefs'                        => 'This chart will never include accounts that have the "Include in net worth"-option unchecked.',


    // charts:
    'chart'                                     => 'Grafik',
    'month'                                     => 'Ay',
    'budget'                                    => 'Bütçe',
    'spent'                                     => 'Harcanan',
    'spent_capped'                              => 'Spent (capped)',
    'spent_in_budget'                           => 'Bütçede harcama',
    'left_to_spend'                             => 'Harcama için bırakıldı',
    'earned'                                    => 'Kazanılan',
    'overspent'                                 => 'Fazladan',
    'left'                                      => 'Ayrıldı',
    'max-amount'                                => 'En yüksek miktar',
    'min-amount'                                => 'Minimum amount',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'İsim',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Tarih',
    'date_and_time'                             => 'Date and time',
    'time'                                      => 'Time',
    'paid'                                      => 'Ödendi',
    'unpaid'                                    => 'Ödenmedi',
    'day'                                       => 'Gün',
    'budgeted'                                  => 'Bütçelenen',
    'period'                                    => 'Dönem',
    'balance'                                   => 'Denge',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Toplam',
    'summary'                                   => 'Summary',
    'average'                                   => 'Ortalama',
    'balanceFor'                                => ':name için bakiye',
    'no_tags'                                   => '(no tags)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => '":name" kumbarasına paraa ekle',
    'piggy_bank'                    => 'Kumbara',
    'new_piggy_bank'                => 'Yeni kumbara',
    'store_piggy_bank'              => 'Yeni bir kumbara kaydet',
    'stored_piggy_bank'             => '":name" isimli yeni bir kumbara kaydet',
    'account_status'                => 'Hesap Durumu',
    'left_for_piggy_banks'          => 'Kumbara için sola',
    'sum_of_piggy_banks'            => 'Kumbaranın toplamı',
    'saved_so_far'                  => 'Şimdiye kadar biriktirilmiş',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Kaydetmek için sola',
    'suggested_amount'              => 'Birikim için önerilen aylık tutar',
    'add_money_to_piggy_title'      => '":name" kumbarasına para ekle',
    'remove_money_from_piggy_title' => '":name" kumbarasından para çek',
    'add'                           => 'Ekle',
    'no_money_for_piggy'            => 'Bu kumbaraya koyacak paran yok.',
    'suggested_savings_per_month'   => 'Aylık önerildi',

    'remove'                    => 'Kaldır',
    'max_amount_add'            => 'Ekleyebileceğiniz azami tutar',
    'max_amount_remove'         => 'Kaldırabileceğiniz maksimum tutar',
    'update_piggy_button'       => 'Kumbarayı güncelle',
    'update_piggy_title'        => '":name" kumbarasını güncelle',
    'updated_piggy_bank'        => '":name" kumbarası güncellenmiş',
    'details'                   => 'Detaylar',
    'events'                    => 'Etkinlikler',
    'target_amount'             => 'Hedef miktar',
    'start_date'                => 'Başlangıç Tarihi',
    'no_start_date'             => 'başlangıç tarihi yok',
    'target_date'               => 'Hedeflenen tarih',
    'no_target_date'            => 'Hedef tarihi yok',
    'table'                     => 'Tablo',
    'delete_piggy_bank'         => '":name" (adlı) kumbarayı sil',
    'cannot_add_amount_piggy'   => '":name" değerine "amount:" eklenemedi.',
    'cannot_remove_from_piggy'  => '":name" adresinden miktar kaldırılamadı.',
    'deleted_piggy_bank'        => '":name" kumbarası silinmiş',
    'added_amount_to_piggy'     => '":name" e kadar olan miktar eklendi',
    'removed_amount_from_piggy' => '":name"\'den :amount" silindi',
    'piggy_events'              => 'Related piggy banks',

    // tags
    'delete_tag'                => '":tag" etiketi sil',
    'deleted_tag'               => '":tag" etiketi silinmiş',
    'new_tag'                   => 'Yeni etiket yap',
    'edit_tag'                  => '":tag" etiketi düzenle',
    'updated_tag'               => 'Güncellenmiş etiket ":tag"',
    'created_tag'               => 'Tag ":tag" oluşturuldu!',

    'transaction_journal_information'               => 'İşlem Bilgileri',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta Bilgisi',
    'transaction_journal_more'                      => 'More information',
    'basic_journal_information'                     => 'Basic transaction information',
    'transaction_journal_extra'                     => 'Extra information',
    'att_part_of_journal'                           => 'Stored under ":journal"',
    'total_amount'                                  => 'Toplam Tutar',
    'number_of_decimals'                            => 'Ondalık Sayı',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Yönetim',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Kullanıcı Yönetimi',
    'list_all_users'                                => 'Tüm kullanıcılar',
    'all_users'                                     => 'Tüm kullanıcılar',
    'instance_configuration'                        => 'Yapılandırma',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Tek kullanıcı modu',
    'setting_single_user_mode_explain'              => 'Varsayılan olarak Firefly III sadece bir kayıt kabul eder: sizi. Bu başkalarının sizin isteklerinizi kontrol etmemesi için bir güvenlik önlemidir. Gelecekteki kayıtlar engellendi. Bu kutunun işaretini kaldırdığınızda erişebildiklerini var sayarsak (internete bağlı olduğunda) başkaları da sizin isteklerinizi kullanabilir.',
    'store_configuration'                           => 'Mağaza yapılandırması',
    'single_user_administration'                    => ':email için kullanıcı yönetimi',
    'edit_user'                                     => ':email kullanıcısını düzenle',
    'hidden_fields_preferences'                     => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                         => 'Kullanıcı bilgisi',
    'user_information'                              => 'Kullanıcı bilgisi',
    'total_size'                                    => 'toplam boyut',
    'budget_or_budgets'                             => ':count budget|:count budgets',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_groups kural gruplarındaki :count_rules kuralları',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'Yapılandırma güncellendi',
    'setting_is_demo_site'                          => 'Tanıtım videosu',
    'setting_is_demo_site_explain'                  => 'Bu kutuyu işaretlediniz, bu yükleme, demo sitesinin sanki garip yan etkilere sahipmiş gibi davranır.',
    'block_code_bounced'                            => 'E-posta mesajı geri çevrildi',
    'block_code_expired'                            => 'Demo hesabı doldu',
    'no_block_code'                                 => 'Engellemek için bir neden yok ya da kullanıcı engellenmemiş',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Kullanıcı henüz yeni bir e-posta adresi teyit etmedi',
    'admin_update_email'                            => 'Profil sayfasının aksine kullanıcı e-posta adresleri değiştirildiğinde bildirim ALMAYACAKLAR!',
    'update_user'                                   => 'Kullanıcıyı güncelle',
    'updated_user'                                  => 'Kullanıcı verileri değiştirildi.',
    'delete_user'                                   => 'Kullanıcıyı sil :email',
    'user_deleted'                                  => 'Kullanıcı silindi',
    'send_test_email'                               => 'E-posta adresine test mesajı gönder',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Mesaj gönder',
    'send_test_triggered'                           => 'Test tetiklendi. Gelen kutunuzu ve kayıt dosyalarınızı kontrol ediniz.',
    'give_admin_careful'                            => 'Users who are given admin rights can take away yours. Be careful.',
    'admin_maintanance_title'                       => 'Maintenance',
    'admin_maintanance_expl'                        => 'Some nifty buttons for Firefly III maintenance',
    'admin_maintenance_clear_cache'                 => 'Clear cache',
    'owner_notifications'                           => 'Yönetici Bildirimleri',
    'owner_notifications_expl'                      => 'Aşağıdaki bildirimler yönetici tarafından etkinleştirilebilir veya devre dışı bırakılabilir. Bu bildirimler, yapılandırılmış TÜM kanallar üzerinden gönderilecektir. Bazı kanallar ortam değişkenlerinizde yapılandırılmıştır, diğerleri ise buradan ayarlanabilir.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Bildirim ayarları',
    'title_owner_notifications'                     => 'Sahip bildirimleri',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Bildirim ayarları',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'Bu kanallar bildirim göndermek için kullanılabilir. Yapılandırmanızı test etmek için aşağıdaki düğmeleri kullanın. Düğmelerin spam kontrolü olmadığını lütfen unutmayın.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'Slack bildirim kanalı, Discord\'a da bildirim gönderebilir.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Description of the split transaction',
    'split_transaction_title_help'          => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'split_title_help'                      => 'If you create a split transaction, there must be a global description for all splits of the transaction.',
    'you_create_transfer'                   => 'You\'re creating a transfer.',
    'you_create_withdrawal'                 => 'You\'re creating a withdrawal.',
    'you_create_deposit'                    => 'You\'re creating a deposit.',

    // links
    'journal_link_configuration'            => 'İşlem bağlantıları yapılandırması',
    'create_new_link_type'                  => 'Yeni bağlantı türü oluştur',
    'store_new_link_type'                   => 'Yeni bağlantı türünü kaydet',
    'update_link_type'                      => 'Bağlantı türünü güncelle',
    'edit_link_type'                        => '":name" bağlantı türünü düzenleyin',
    'updated_link_type'                     => '":name" bağlantı türünü güncelleyin',
    'delete_link_type'                      => '":name" bağlantı türünü silin',
    'deleted_link_type'                     => '":name" bağlantı türü silinmiş',
    'stored_new_link_type'                  => '":name" yeni bağlantı türünü kaydet',
    'cannot_edit_link_type'                 => '":name" bağlantı türü düzenlenemiyor',
    'link_type_help_name'                   => 'Yani "Kopyalar"',
    'link_type_help_inward'                 => 'Yani "kopyalar"',
    'link_type_help_outward'                => 'Yani "tarafından çoğaltılmış"',
    'save_connections_by_moving'            => 'Save the link between these transactions by moving them to another link type:',
    'do_not_save_connection'                => '(bağlantıyı kaydetme)',
    'link_transaction'                      => 'Bağlantı işlemi',
    'link_to_other_transaction'             => 'Bu işlemi başka bir işlemle bağlantılandır',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Bu işlem',
    'transaction'                           => 'İşlem',
    'comments'                              => 'Yorumlar',
    'link_notes'                            => 'Any notes you wish to store with the link.',
    'invalid_link_selection'                => 'Bu işlemler bağlantılanamıyor',
    'selected_transaction'                  => 'Selected transaction',
    'journals_linked'                       => 'İşlemler bağlantıları oluşturuldu.',
    'journals_error_linked'                 => 'Bu işlemler zaten bağlantılı.',
    'journals_link_to_self'                 => 'Kendisi için bir ilişki ekleyemezsiniz.',
    'journal_links'                         => 'İşlem bağlantıları',
    'this_withdrawal'                       => 'Bu çekim',
    'this_deposit'                          => 'Bu depozito',
    'this_transfer'                         => 'Bu transfer',
    'overview_for_link'                     => '":name" bağlantı tipine genel bakış',
    'source_transaction'                    => 'İşlem kaynağı',
    'link_description'                      => 'Bağlantı açıklaması',
    'destination_transaction'               => 'Hedef işlem',
    'delete_journal_link'                   => '<a href=":source_link">:source</a>ve<a href=":destination_link">:destination</a> arasında bağlantıyı sil',
    'deleted_link'                          => 'Bağlantı silindi',

    // link translations:
    'Paid_name'                             => 'Paid',
    'Refund_name'                           => 'Refund',
    'Reimbursement_name'                    => 'Reimbursement',
    'Related_name'                          => 'Related',
    'relates to_inward'                     => 'ile ilişkili',
    'is (partially) refunded by_inward'     => 'tarafından (kısmen) geri ödendi',
    'is (partially) paid for by_inward'     => 'tarafından (kısmen) ödendi',
    'is (partially) reimbursed by_inward'   => 'tarafından (kısmen) iade edildi',
    'inward_transaction'                    => 'Içe işlem',
    'outward_transaction'                   => 'Dış işlem',
    'relates to_outward'                    => 'ile ilişkili',
    '(partially) refunds_outward'           => '(kısmen) geri ödeme',
    '(partially) pays for_outward'          => 'için (kısmen) öder',
    '(partially) reimburses_outward'        => '(kısmen) iade edilir',
    'is (partially) refunded by'            => 'is (partially) refunded by',
    'is (partially) paid for by'            => 'is (partially) paid for by',
    'is (partially) reimbursed by'          => 'is (partially) reimbursed by',
    'relates to'                            => 'relates to',
    '(partially) refunds'                   => '(partially) refunds',
    '(partially) pays for'                  => '(partially) pays for',
    '(partially) reimburses'                => '(partially) reimburses',

    // split a transaction:
    'splits'                                => 'Bölmeler',
    'add_another_split'                     => 'Başka bir bölme ekle',
    'cannot_edit_opening_balance'           => 'Bir hesabın açılış bakiyesini düzenleyemezsiniz.',
    'no_edit_multiple_left'                 => 'Düzenlemek için geçerli İşlemler seçmediniz.',
    'breadcrumb_convert_group'              => 'Convert transaction',
    'convert_invalid_source'                => 'Source information is invalid for transaction #%d.',
    'convert_invalid_destination'           => 'Destination information is invalid for transaction #%d.',
    'create_another'                        => 'After storing, return here to create another one.',
    'after_update_create_another'           => 'After updating, return here to continue editing.',
    'store_as_new'                          => 'Store as a new transaction instead of updating.',
    'reset_after'                           => 'Reset form after submission',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(ungrouped)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Bir varlık hesabı oluşturalım!',
    'no_accounts_intro_asset'               => 'Henüz varlık hesabınız yok. Varlık hesapları ana hesaplarınızdır: çek hesabı, birikim hesabı, paylaşılan hesabınız veya kredi kartınız.',
    'no_accounts_imperative_asset'          => 'Firefly III kullanmaya başlamak için en az bir varlık hesabı açmanız gerekir. Hadi şimdi yapalım:',
    'no_accounts_create_asset'              => 'Yeni varlık hesabı oluştur',
    'no_accounts_title_expense'             => 'Haydi bir gider hesabı oluşturalım!',
    'no_accounts_intro_expense'             => 'Henüz gider hesaplarınız yok. Gider hesapları parayı harcadığınız yerdir, dükkanlar ve süpermarketler gibi.',
    'no_accounts_imperative_expense'        => 'Gider hesapları işlemler oluşturduğunuzda otomatik olarak oluşturulur, ama eğer isterseniz manuel olarak da bir tane oluşturabilirsiniz. Haydi şimdi bir tane oluşturalım:',
    'no_accounts_create_expense'            => 'Bir masraf hesabı oluştur',
    'no_accounts_title_revenue'             => 'Gelir hesabı oluşturalım!',
    'no_accounts_intro_revenue'             => 'Henüz gelir hesaplarınız yok. Gelir hesapları para almanızı sağlayan yerdir, tıpkı işvereniniz gibi.',
    'no_accounts_imperative_revenue'        => 'Gelir hesapları, işlemler oluşturduğunuzda otomatikmen oluşturulur, ama isterseniz manuel olarak da bir tane oluşturabilirsiniz. Hadi şimdi bir tane oluşturalım:',
    'no_accounts_create_revenue'            => 'Bir gelir hesabı oluşturun',
    'no_accounts_title_liabilities'         => 'Let\'s create a liability!',
    'no_accounts_intro_liabilities'         => 'You have no liabilities yet. Liabilities are the accounts that register your (student) loans and other debts.',
    'no_accounts_imperative_liabilities'    => 'You don\'t have to use this feature, but it can be useful if you want to keep track of these things.',
    'no_accounts_create_liabilities'        => 'Create a liability',
    'no_budgets_title_default'              => 'Bütçe oluşturalım',
    'no_rules_title_default'                => 'Let\'s create a rule',
    'no_budgets_intro_default'              => 'You have no budgets yet. Budgets are used to organize your expenses into logical groups, which you can give a soft-cap to limit your expenses.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Bütçeler, finansal yönetimin temel araçlarıdır. Şimdi bir tane oluşturalım:',
    'no_budgets_create_default'             => 'Bir bütçe oluştur',
    'no_rules_create_default'               => 'Create a rule',
    'no_categories_title_default'           => 'Bir kategori oluşturalım!',
    'no_categories_intro_default'           => 'Henüz kategorileriniz yok. Kategoriler işlemlerinizi ayrıntılı ayarlamak ve onları belirlenmiş olan kategorilere etiketlemenize yarar.',
    'no_categories_imperative_default'      => 'Kategoriler, işlemler oluşturduğunuzda otomatikmen oluşturulur, ama siz manuel olarak da oluşturabilirsiniz. Hadi bir tane oluşturalım:',
    'no_categories_create_default'          => 'Bir kategori oluştur',
    'no_tags_title_default'                 => 'Bir etiket oluşturalım!',
    'no_tags_intro_default'                 => 'Henüz etiketler yok. Etiketler, işlemlerinizi ayrıntılı ayarlamak ve onları özel anahtar kelimelerle etiketlemenize yarar.',
    'no_tags_imperative_default'            => 'Etiketler, işlemler oluşturduğunuzda otomatikmen oluşturulur, ama siz manuel olarak da oluşturabilirsiniz. Haydi bir tane oluşturalım şimdi:',
    'no_tags_create_default'                => 'Etiket oluştur',
    'no_transactions_title_withdrawal'      => 'Hadi bir gider oluşturalım!',
    'no_transactions_intro_withdrawal'      => 'Henüz giderleriniz yok. Maliyenizi yönetmek için giderler oluşturmanız gerekir.',
    'no_transactions_imperative_withdrawal' => 'Biraz para harcadın mı? O zaman şunu yazmalısın:',
    'no_transactions_create_withdrawal'     => 'Bir gider oluştur',
    'no_transactions_title_deposit'         => 'Bir kaç gelir oluşturalım!',
    'no_transactions_intro_deposit'         => 'Kayıtlı bir geliriniz henüz yok. Giderlerinizi yönetmeye başlamak için gelir girdileri oluşturmalısınız.',
    'no_transactions_imperative_deposit'    => 'Biraz para aldınız mı? Ozaman aşağıya yazmanız gerekir:',
    'no_transactions_create_deposit'        => 'Para yatırma',
    'no_transactions_title_transfers'       => 'Bir transfer oluşturalım!',
    'no_transactions_intro_transfers'       => 'Henüz bir transferiniz yok. Varlık hesapları arasında para taşıdığınızda, bir transfer olarak kaydedilir.',
    'no_transactions_imperative_transfers'  => 'Biraz para mı harcadın? O zaman onu aşağıya yazmalısın:',
    'no_transactions_create_transfers'      => 'Aktarma oluştur',
    'no_piggies_title_default'              => 'Bir kumbara oluşturalım!',
    'no_piggies_intro_default'              => 'Henüz kumbaranız yok. Kazançlarınızı bölmek ve ne kazandığınızı izlemek için kumbaralar oluşturabilirsiniz.',
    'no_piggies_imperative_default'         => 'Para biriktirdiğiniz birşeyler var mı? Bir kumbara oluşturun ve takip edin:',
    'no_piggies_create_default'             => 'Yeni bir kumbara yarat',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Tekrar Eden İşlemler',
    'repeat_until_in_past'                  => 'This recurring transaction stopped repeating on :date.',
    'recurring_calendar_view'               => 'Calendar',
    'no_recurring_title_default'            => 'Yinelenen bir işlem yapalım!',
    'no_recurring_intro_default'            => 'Henüz yinelenen işleminiz yok. Firefly III\'ün sizin için otomatik olarak işlemler oluşturmasını sağlamak için bunları kullanabilirsiniz.',
    'no_recurring_imperative_default'       => 'Bu oldukça gelişmiş bir özelliktir ve son derece kullanışlı olabilir. Devam etmeden önce, (?) - sağ üst köşedeki dokümanları okuduğunuzdan emin olun.',
    'no_recurring_create_default'           => 'Yinelenen bir işlem oluştur',
    'make_new_recurring'                    => 'Yinelenen bir işlem oluştur',
    'recurring_daily'                       => 'Her gün',
    'recurring_weekly'                      => 'Every week on :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Every month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_monthly_skip'                => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_ndom'                        => 'Every month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Every year on :date',
    'overview_for_recurrence'               => 'Overview for recurring transaction ":title"',
    'warning_duplicates_repetitions'        => 'In rare instances, dates appear twice in this list. This can happen when multiple repetitions collide. Firefly III will always generate one transaction per day.',
    'created_transactions'                  => 'İlişkili işlemler',
    'expected_withdrawals'                  => 'Expected withdrawals',
    'expected_deposits'                     => 'Expected deposits',
    'expected_transfers'                    => 'Expected transfers',
    'created_withdrawals'                   => 'Created withdrawals',
    'created_deposits'                      => 'Created deposits',
    'created_transfers'                     => 'Created transfers',
    'recurring_info'                        => 'Recurring transaction :count / :total',
    'created_from_recurrence'               => 'Created from recurring transaction ":title" (#:id)',
    'recurring_never_cron'                  => 'It seems the cron job that is necessary to support recurring transactions has never run. This is of course normal when you have just installed Firefly III, but this should be something to set up as soon as possible. Please check out the help-pages using the (?)-icon in the top right corner of the page.',
    'recurring_cron_long_ago'               => 'It looks like it has been more than 36 hours since the cron job to support recurring transactions has fired for the last time. Are you sure it has been set up correctly? Please check out the help-pages using the (?)-icon in the top right corner of the page.',

    'create_new_recurrence'              => 'Yinelenen bir işlem oluştur',
    'help_first_date'                    => 'Indicate the first expected recurrence. This must be in the future.',
    'help_first_date_no_past'            => 'Indicate the first expected recurrence. Firefly III will not create transactions in the past.',
    'no_currency'                        => '(no currency)',
    'mandatory_for_recurring'            => 'Mandatory recurrence information',
    'mandatory_for_transaction'          => 'Mandatory transaction information',
    'optional_for_recurring'             => 'Optional recurrence information',
    'optional_for_transaction'           => 'Optional transaction information',
    'change_date_other_options'          => 'Change the "first date" to see more options.',
    'mandatory_fields_for_tranaction'    => 'The values here will end up in the transaction(s) being created',
    'click_for_calendar'                 => 'Click here for a calendar that shows you when the transaction would repeat.',
    'repeat_forever'                     => 'Repeat forever',
    'repeat_until_date'                  => 'Repeat until date',
    'repeat_times'                       => 'Repeat a number of times',
    'recurring_skips_one'                => 'Every other',
    'recurring_skips_more'               => 'Skips :count occurrences',
    'store_new_recurrence'               => 'Store recurring transaction',
    'stored_new_recurrence'              => 'Recurring transaction ":title" stored successfully.',
    'edit_recurrence'                    => 'Edit recurring transaction ":title"',
    'recurring_repeats_until'            => 'Repeats until :date',
    'recurring_repeats_forever'          => 'Repeats forever',
    'recurring_repeats_x_times'          => 'Repeats :count time|Repeats :count times',
    'update_recurrence'                  => 'Update recurring transaction',
    'updated_recurrence'                 => 'Updated recurring transaction ":title"',
    'recurrence_is_inactive'             => 'This recurring transaction is not active and will not generate new transactions.',
    'delete_recurring'                   => 'Delete recurring transaction ":title"',
    'new_recurring_transaction'          => 'New recurring transaction',
    'help_weekend'                       => 'What should Firefly III do when the recurring transaction falls on a Saturday or Sunday?',
    'do_nothing'                         => 'Just create the transaction',
    'skip_transaction'                   => 'Skip the occurrence',
    'jump_to_friday'                     => 'Create the transaction on the previous Friday instead',
    'jump_to_monday'                     => 'Create the transaction on the next Monday instead',
    'will_jump_friday'                   => 'Will be created on Friday instead of the weekends.',
    'will_jump_monday'                   => 'Will be created on Monday instead of the weekends.',
    'except_weekends'                    => 'Except weekends',
    'recurrence_deleted'                 => 'Recurring transaction ":title" deleted',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balance (:currency)',
    'box_spent_in_currency'              => 'Spent (:currency)',
    'box_earned_in_currency'             => 'Earned (:currency)',
    'box_budgeted_in_currency'           => 'Budgeted (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Left to spend (:currency)',
    'box_net_worth_in_currency'          => 'Net worth (:currency)',
    'box_spend_per_day'                  => 'Left to spend per day: :amount',

    // debug page
    'debug_page'                         => 'Debug page',
    'debug_submit_instructions'          => 'If you are running into problems, you can use the information in this box as debug information. Please copy-and-paste into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. It will generate a beautiful table that can be used to quickly diagnose your problem.',
    'debug_pretty_table'                 => 'If you copy/paste the box below into a GitHub issue it will generate a table. Please do not surround this text with backticks or quotes.',
    'debug_additional_data'              => 'You may also share the content of the box below. You can also copy-and-paste this into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. However, the content of this box may contain private information such as account names, transaction details or email addresses.',

    // object groups
    'object_groups_menu_bar'             => 'Groups',
    'object_groups_page_title'           => 'Groups',
    'object_groups_breadcrumb'           => 'Groups',
    'object_groups_index'                => 'Overview',
    'object_groups'                      => 'Groups',
    'object_groups_empty_explain'        => 'Some things in Firefly III can be divided into groups. Piggy banks for example, feature a "Group" field in the edit and create screens. When you set this field, you can edit the names and the order of the groups on this page. For more information, check out the help-pages in the top right corner, under the (?)-icon.',
    'object_group_title'                 => 'Title',
    'edit_object_group'                  => 'Edit group ":title"',
    'delete_object_group'                => 'Delete group ":title"',
    'update_object_group'                => 'Update group',
    'updated_object_group'               => 'Successfully updated group ":title"',
    'deleted_object_group'               => 'Successfully deleted group ":title"',
    'object_group'                       => 'Group',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Para birimi dönüştürmeyi etkinleştir',
    'disable_auto_convert'               => 'Para birimi dönüştürmeyi devre dışı bırak',
];
