<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Názov banky',
    'bank_balance'                 => 'Zostatok',
    'current_balance'              => 'Current balance',
    'savings_balance'              => 'Zostatok úspor',
    'credit_card_limit'            => 'Limit kreditnej karty',
    'automatch'                    => 'Hľadať zhodu automaticky',
    'skip'                         => 'Preskočiť',
    'enabled'                      => 'Zapnuté',
    'name'                         => 'Názov',
    'active'                       => 'Aktívne',
    'amount_min'                   => 'Minimálna suma',
    'amount_max'                   => 'Maximálna suma',
    'match'                        => 'Zhoda',
    'strict'                       => 'Striktný režim',
    'repeat_freq'                  => 'Opakuje sa',
    'object_group'                 => 'Skupina',
    'location'                     => 'Údaje o polohe',
    'update_channel'               => 'Kanál aktualizácií',
    'currency_id'                  => 'Mena',
    'transaction_currency_id'      => 'Mena',
    'auto_budget_currency_id'      => 'Mena',
    'external_ip'                  => 'Externá IP adresa vášho serveru',
    'attachments'                  => 'Prílohy',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Overiť bezpečnosť hesla',
    'source_account'               => 'Zdrojový účet',
    'destination_account'          => 'Cieľový účet',
    'asset_destination_account'    => 'Cieľový účet',
    'include_net_worth'            => 'Zahrnúť do čistého majetku',
    'asset_source_account'         => 'Zdrojový účet',
    'journal_description'          => 'Popis',
    'note'                         => 'Poznámky',
    'currency'                     => 'Mena',
    'account_id'                   => 'Účet aktív',
    'budget_id'                    => 'Rozpočet',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => 'Počiatočný zostatok',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Virtuálnu zostatok',
    'run_after_form' => 'Run this rule',



    'targetamount'                 => 'Cieľová suma',
    'target_amount'                => 'Target amount',
    'account_role'                 => 'Rola účtu',
    'opening_balance_date'         => 'Dátum počiatočného zostatku',
    'cc_type'                      => 'Zúčtovacie obdobie kreditnej karty',
    'cc_monthly_payment_date'      => 'Dátum mesačnej úhrady kreditnej karty',
    'piggy_bank_id'                => 'Pokladnička',
    'returnHere'                   => 'Vrátiť sa sem',
    'returnHereExplanation'        => 'Po uložení vytvoriť ďalší.',
    'returnHereUpdateExplanation'  => 'Po aktualizácii sa sem vrátiť.',
    'description'                  => 'Popis',
    'expense_account'              => 'Výdajový účet',
    'revenue_account'              => 'Príjmový účet',
    'decimal_places'               => 'Desatinné miesta',
    'destination_amount'           => 'Suma (cieľ)',
    'new_email_address'            => 'Nová e-mailová adresa',
    'verification'                 => 'Overenie',
    'api_key'                      => 'Kľúč k API',
    'remember_me'                  => 'Zapamätať si ma',
    'liability_type_id'            => 'Typ záväzku',
    'liability_type'               => 'Typ záväzku',
    'interest'                     => 'Úrok',
    'interest_period'              => 'Úrokové obdobie',
    'extension_date'               => 'Extension date',
    'type'                         => 'Typ',
    'convert_Withdrawal'           => 'Konvertovať výber',
    'convert_Deposit'              => 'Konvertovať vklad',
    'convert_Transfer'             => 'Konvertovať převod',
    'amount'                       => 'Suma',
    'foreign_amount'               => 'Suma v cudzej mene',
    'date'                         => 'Dátum',
    'interest_date'                => 'Úrokový dátum',
    'book_date'                    => 'Dátum rezervácie',
    'process_date'                 => 'Dátum spracovania',
    'category'                     => 'Kategórie',
    'tags'                         => 'Štítky',
    'deletePermanently'            => 'Permanentne odstrániť',
    'cancel'                       => 'Storno',
    'targetdate'                   => 'Cieľový dátum',
    'target_date'                  => 'Target date',
    'startdate'                    => 'Dátum zahájenia',
    'start_date'                   => 'Start date',
    'tag'                          => 'Štítok',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Pod',
    'symbol'                       => 'Symbol',
    'code'                         => 'Kód',
    'iban'                         => 'IBAN',
    'account_number'               => 'Číslo účtu',
    'creditCardNumber'             => 'Číslo kreditnej karty',
    'has_headers'                  => 'Hlavičky',
    'date_format'                  => 'Formát dátumu',
    'attachments[]'                => 'Prílohy',
    'title'                        => 'Názov',
    'notes'                        => 'Poznámky',
    'filename'                     => 'Názov súboru',
    'mime'                         => 'Typ MIME',
    'size'                         => 'Veľkosť',
    'trigger'                      => 'Spúšťač',
    'stop_processing'              => 'Zastaviť spracovanie',
    'end_date'                     => 'End date',
    'enddate'                      => 'End date',
    'move_rules_before_delete'     => 'Rule group',
    'start'                        => 'Začiatok rozsahu',
    'end'                          => 'Koniec rozsahu',
    'delete_account'               => 'Odstrániť účet „:name“',
    'delete_webhook'               => 'Delete webhook ":title"',
    'delete_bill'                  => 'Delete subscription ":name"',
    'delete_budget'                => 'Odstrániť rozpočet „:name“',
    'delete_category'              => 'Odstrániť kategóriu „:name“',
    'delete_currency'              => 'Odstrániť menu „:name“',
    'delete_journal'               => 'Odstrániť transakciu, ktorá má popis „:description“',
    'delete_attachment'            => 'Odstrániť prílohu „:name“',
    'delete_rule'                  => 'Odstrániť pravidlo „:title“',
    'delete_rule_group'            => 'Odstrániť skupinu pravidiel „:title“',
    'delete_link_type'             => 'Odstrániť odkaz typu „:name“',
    'delete_user'                  => 'Odstrániť použivateľa „:email“',
    'delete_recurring'             => 'Odstrániť opakovanú transakciu „:title“',
    'user_areYouSure'              => 'Ak odstránite používateľa ":email“, všetko zmizne. Nie je možné vrátiť sa späť, obnoviť, nič. Ak odstránite sami seba, stratíte prístup k tejto inštancii Firefly III.',
    'attachment_areYouSure'        => 'Skutočne chcete odstrániť prílohu s názvom ":name"?',
    'account_areYouSure'           => 'Skutočne chcete odstrániť účet s názvom ":name"?',
    'account_areYouSure_js'        => 'Skutočne chcete odstrániť účet s názvom "{name}"?',
    'bill_areYouSure'              => 'Are you sure you want to delete the subscription named ":name"?',
    'rule_areYouSure'              => 'Skutočne chcete odstrániť pravidlo s názvom ":title"?',
    'object_group_areYouSure'      => 'Skutočne chcete odstrániť skupinu s názvom ":title"?',
    'ruleGroup_areYouSure'         => 'Skutočne chcete odstrániť skupinu pravidiel s názvom ":title"?',
    'budget_areYouSure'            => 'Skutočne chcete odstrániť rozpočet s názvom ":name"?',
    'webhook_areYouSure'           => 'Are you sure you want to delete the webhook named ":title"?',
    'category_areYouSure'          => 'Skutočne chcete odstrániť kategóriu s názvom ":name"?',
    'recurring_areYouSure'         => 'Skutočne chcete odstrániť opakovanú transakciu s názvom ":title"?',
    'currency_areYouSure'          => 'Skutočne chcete odstrániť menu s názvom ":name"?',
    'piggyBank_areYouSure'         => 'Skutočne chcete odstrániť pokladničku s názvom ":name"?',
    'journal_areYouSure'           => 'Skutočne chcete odstrániť transakciu popísanú ":description"?',
    'mass_journal_are_you_sure'    => 'Skutočne chcete odstrániť tieto transakcie?',



    'tag_areYouSure'               => 'Skutočne chcete odstrániť značku ":tag"?',
    'journal_link_areYouSure'      => 'Skutočne chcete odstrániť previazanie medzi <a href=":source_link">:source</a> a <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Skutočne chcete odstrániť previazanie typu ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Odstránenie údajov z Firefly III je trvalé a nie je možné ich vrátiť späť.',
    'mass_make_selection'          => 'Stále môžete zabrániť vymazaniu položiek ich odznačením.',
    'delete_all_permanently'       => 'Permanentne odstrániť označené záznamy',
    'update_all_journals'          => 'Aktualizovať tieto transakcie',
    'also_delete_transactions'     => 'Odstráni sa aj jediná transakcia spojená s týmto účtom.|Odstráni sa tiež :count transakcií spojených s týmto účtom.',
    'also_delete_transactions_js'  => 'Žiadne transakcie|Odstráni sa aj jediná transakcia spojená s týmto účtom.|Odstráni sa tiež {count} transakcií spojených s týmto účtom.',
    'also_delete_connections'      => 'Jediná transakcia spojená s týmto typom odkazu stratí toto pripojenie.|Všetkých :count transakcií prepojených s týmto typom odkazu stratí svoje pripojenie.',
    'also_delete_rules'            => 'Odstráni sa aj jediné pravidlo spojené s touto skupinou pravidiel.|Odstráni sa tiež :count pravidiel spojených s touto skupinou pravidiel.',
    'also_delete_piggyBanks'       => 'Odstráni sa tiež jediné prasiatko prepojené s týmto účtom.|Odstráni sa tiež :count prasiatok prepojených s týmto účtom.',
    'also_delete_piggyBanks_js'    => 'Žiadne prasiatko|Odstráni sa tiež jediné prasiatko prepojené s týmto účtom.|Odstráni sa tiež {count} prasiatok prepojených s týmto účtom.',
    'not_delete_piggy_banks'       => 'Prasiatko prepojené s touto skupinou nebude odstránené.|:count prasiatok prepojených s touto skupinou nebude odstránených.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => 'Jediná transakcia spojená s týmto rozpočtom nebude odstránená.|:count transakcií prepojených s týmto rozpočtom nebude odstránených.',
    'category_keep_transactions'   => 'Jediná transakcia spojená s touto kategóriou nebude odstránená.|:count transakcií prepojených s touto kategóriou nebude odstránených.',
    'recurring_keep_transactions'  => 'Jediná transakcia spojená s touto opakujúcou sa transakciou nebude odstránená.|:count transakcií prepojených s touto opakujúcou sa transakciou nebude odstránených.',
    'tag_keep_transactions'        => 'Jediná transakcia spojená s týmto účtom nebude odstránená.|:count transakcií prepojených s týmto štítkom nebude odstránených.',
    'check_for_updates'            => 'Zjistit dostupnost případných aktualizací',
    'liability_direction'          => 'Záväzky príjem/výdaj',
    'delete_object_group'          => 'Odstrániť skupinu ":title“',
    'email'                        => 'E-mailová adresa',
    'password'                     => 'Heslo',
    'password_confirmation'        => 'Heslo (kontrola)',
    'blocked'                      => 'Je blokovaný?',
    'blocked_code'                 => 'Dôvod blokovania',
    'login_name'                   => 'Prihlasovacie meno',
    'is_owner'                     => 'Je správca?',
    'url'                          => 'URL',
    'bill_end_date'                => 'End date',

    // import
    'apply_rules'                  => 'Uplatniť pravidlá',
    'artist'                       => 'Umelec',
    'album'                        => 'Album',
    'song'                         => 'Skladba',

    // admin
    'domain'                       => 'Doména',
    'single_user_mode'             => 'Vypnúť možnosť registrácie použivateľov',
    'is_demo_site'                 => 'Je demostránka',

    // import
    'configuration_file'           => 'Súbor s nastaveniami',
    'csv_comma'                    => 'Čiarka (,)',
    'csv_semicolon'                => 'Bodkočiarka (;)',
    'csv_tab'                      => 'Tabulátor (neviditeľný)',
    'csv_delimiter'                => 'Oddeľovač polí v CSV',
    'client_id'                    => 'Identif. klienta',
    'app_id'                       => 'Identif. aplikácie',
    'secret'                       => 'Tajný kľúč',
    'public_key'                   => 'Verejná časť kľúča',
    'country_code'                 => 'Kód krajiny',
    'provider_code'                => 'Banka alebo poskytovateľ údajov',
    'fints_url'                    => 'URL adresa FinTS API',
    'fints_port'                   => 'Port',
    'fints_bank_code'              => 'Kód banky',
    'fints_username'               => 'Použivateľské meno',
    'fints_password'               => 'PIN kód / heslo',
    'fints_account'                => 'FinTS účet',
    'local_account'                => 'Účet Firefly III',



    'from_date'                    => 'Od dátumu',
    'to_date'                      => 'Do dátumu',
    'due_date'                     => 'Dátum splatnosti',
    'payment_date'                 => 'Dátum úhrady',
    'invoice_date'                 => 'Dátum vystavenia',
    'internal_reference'           => 'Interná referencia',
    'inward'                       => 'Príchodzí popis',
    'outward'                      => 'Odchádzajúci popis',
    'rule_group_id'                => 'Skupina pravidiel',
    'transaction_description'      => 'Popis transakcie',
    'first_date'                   => 'Prvý dátum',
    'transaction_type'             => 'Typ transakcie',
    'repeat_until'                 => 'Opakovať do',
    'recurring_description'        => 'Popis opakujúcej sa transakcie',
    'repetition_type'              => 'Typ opakovania',
    'foreign_currency_id'          => 'Zahraničná mena',
    'repetition_end'               => 'Opakovanie končí',
    'repetitions'                  => 'Opakovaní',
    'calendar'                     => 'Kalendár',
    'weekend'                      => 'Víkend',
    'client_secret'                => 'Tajný kľúč klienta',
    'withdrawal_destination_id'    => 'Cieľový účet',
    'deposit_source_id'            => 'Zdrojový účet',
    'expected_on'                  => 'Očakávané',
    'paid'                         => 'Uhradené',
    'auto_budget_type'             => 'Auto-rozpočet',
    'auto_budget_amount'           => 'Suma auto-rozpočtu',
    'auto_budget_period'           => 'Obdobie automatického rozpočtu',
    'collected'                    => 'Zozbierané',
    'submitted'                    => 'Odoslané',
    'key'                          => 'Kľúč',
    'value'                        => 'Obsah záznamu',
    'webhook_delivery'             => 'Delivery',
    'webhook_response'             => 'Response',
    'webhook_trigger'              => 'Trigger',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy username',
    'ntfy_pass'                    => 'Ntfy password',
];
