<?php

/**
 * intro.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // index
    'index_intro'                                                     => 'Bem-vindo(a) à página inicial do Firefly III. Aproveite e acompanhe esta introdução para ter uma ideia de como funciona.',
    'index_accounts-chart'                                            => 'Este gráfico mostra o saldo atual de suas contas de ativos. Você pode selecionar as contas visíveis aqui nas suas preferências.',
    'index_box_out_holder'                                            => 'Esta pequena caixa e as caixas próximas a esta lhe darão uma rápida visão geral de sua situação financeira.',
    'index_help'                                                      => 'Se você precisar de ajuda com uma página ou um formulário, pressione este botão.',
    'index_outro'                                                     => 'A maioria das páginas do Firefly III começará com uma pequena turnê como esta. Entre em contato comigo quando tiver dúvidas ou comentários. Aproveite!',
    'index_sidebar-toggle'                                            => 'Para criar novas transações, contas ou outras coisas, use o menu dentro deste ícone.',
    'index_cash_account'                                              => 'Estas são as contas criadas até agora. Você pode usar a conta de caixa para rastrear as despesas de caixa, mas não é obrigatório, claro.',

    // transactions
    'transactions_create_basic_info'                                  => 'Insira as informações básicas de sua transação. Origem, destino, data e descrição.',
    'transactions_create_amount_info'                                 => 'Insira o valor da transação. Caso necessário, os campos serão atualizados automaticamente para informações de valor estrangeiro.',
    'transactions_create_optional_info'                               => 'Todos estes campos são opcionais. Adicionar meta-dados aqui fará suas transações melhor organizadas.',
    'transactions_create_split'                                       => 'Caso você queira dividir uma transação, adicione mais divisões com este botão',

    // create account:
    'accounts_create_iban'                                            => 'Dê a suas contas um IBAN válido. Isso poderá tornar a importação de dados muito fácil no futuro.',
    'accounts_create_asset_opening_balance'                           => 'As contas de ativos podem ter um "saldo de abertura", indicando o início do histórico desta conta no Firefly III.',
    'accounts_create_asset_currency'                                  => 'Firefly III suporta múltiplas moedas. As contas de ativos têm uma moeda principal, que você deve definir aqui.',
    'accounts_create_asset_virtual'                                   => 'Às vezes, ajuda a dar à sua conta um saldo virtual: um valor extra sempre adicionado ou removido do saldo real.',

    // budgets index
    'budgets_index_intro'                                             => 'Os orçamentos são usados ​​para gerenciar suas finanças e formar uma das principais funções do Firefly III.',
    'budgets_index_see_expenses_bar'                                  => 'Gastar dinheiro vai preencher lentamente esta barra.',
    'budgets_index_navigate_periods'                                  => 'Navegue por períodos para definir os orçamentos facilmente antes do tempo.',
    'budgets_index_new_budget'                                        => 'Crie novos orçamentos conforme for entendendo o programa.',
    'budgets_index_list_of_budgets'                                   => 'Use esta tabela para definir os montantes para cada orçamento e veja como você está fazendo.',
    'budgets_index_outro'                                             => 'Para saber mais sobre criar orçamentos, clique no ícone de ajuda no canto superior direito.',



    // reports (index)
    'reports_index_intro'                                             => 'Use esses relatórios para obter informações detalhadas sobre suas finanças.',
    'reports_index_inputReportType'                                   => 'Escolha um tipo de relatório. Confira as páginas de ajuda para ver o que cada relatório mostra.',
    'reports_index_inputAccountsSelect'                               => 'Você pode excluir ou incluir contas de ativos de acordo com a sua demanda.',
    'reports_index_inputDateRange'                                    => 'O intervalo de datas selecionado depende só de você: de um dia até 10 anos ou mais.',
    'reports_index_extra-options-box'                                 => 'Dependendo do relatório que você selecionou, você pode usar filtros e opções adicionais aqui. Observe esta caixa quando você altera os tipos de relatórios.',

    // reports (reports)
    'reports_report_default_intro'                                    => 'Este relatório lhe dará uma visão geral rápida e abrangente de suas finanças. Se você deseja ver mais alguma coisa, não hesite em contactar-me!',
    'reports_report_audit_intro'                                      => 'Este relatório fornecerá informações detalhadas sobre suas contas de ativos.',
    'reports_report_audit_optionsBox'                                 => 'Use essas caixas de seleção para mostrar ou ocultar as colunas em que você está interessado.',

    'reports_report_category_intro'                                   => 'Este relatório lhe dará uma visão em uma ou várias categorias.',
    'reports_report_category_pieCharts'                               => 'Esses gráficos fornecerão informações sobre despesas e receitas por categoria ou por conta.',
    'reports_report_category_incomeAndExpensesChart'                  => 'Este gráfico mostra suas despesas e receitas por categoria.',

    'reports_report_tag_intro'                                        => 'Este relatório lhe dará uma visão de uma ou várias tags.',
    'reports_report_tag_pieCharts'                                    => 'Esses gráficos fornecerão informações sobre despesas e receitas por tag, conta, categoria ou orçamento.',
    'reports_report_tag_incomeAndExpensesChart'                       => 'Este gráfico mostra suas despesas e receita por tag.',

    'reports_report_budget_intro'                                     => 'Este relatório lhe dará uma visão em um ou vários orçamentos.',
    'reports_report_budget_pieCharts'                                 => 'Esses gráficos fornecerão informações sobre despesas por orçamento ou por conta.',
    'reports_report_budget_incomeAndExpensesChart'                    => 'Este gráfico mostra suas despesas por orçamento.',

    // create transaction
    'transactions_create_switch_box'                                  => 'Use esses botões para mudar rapidamente o tipo de transação que deseja salvar.',
    'transactions_create_ffInput_category'                            => 'Você pode digitar livremente neste campo. As categorias criadas anteriormente serão sugeridas.',
    'transactions_create_withdrawal_ffInput_budget'                   => 'Vincule sua retirada a um orçamento para um melhor controle financeiro.',
    'transactions_create_withdrawal_currency_dropdown_amount'         => 'Use este menu quando seu depósito estiver em outra moeda.',
    'transactions_create_deposit_currency_dropdown_amount'            => 'Use este menu suspenso quando seu depósito estiver em outra moeda.',
    'transactions_create_transfer_ffInput_piggy_bank_id'              => 'Selecione um cofrinho e vincule essa transferência às suas economias.',

    // piggy banks index:
    'piggy-banks_index_saved'                                         => 'Este campo mostra o quanto você salvou em cada cofrinho.',
    'piggy-banks_index_button'                                        => 'Ao lado desta barra de progresso estão dois botões (+ e -) para adicionar ou remover dinheiro de cada cofrinho.',
    'piggy-banks_index_accountStatus'                                 => 'Para cada conta de ativos com pelo menos um cofrinho, o status está listado nesta tabela.',



    // create piggy
    'piggy-banks_create_name'                                         => 'Qual é o teu objetivo? Um novo sofá, uma câmera, dinheiro para emergências?',
    'piggy-banks_create_date'                                         => 'Você pode definir uma data-alvo ou um prazo para seu cofrinho.',

    // show piggy
    'piggy-banks_show_piggyChart'                                     => 'Este gráfico mostrará o histórico desse cofrinho.',
    'piggy-banks_show_piggyDetails'                                   => 'Alguns detalhes sobre o seu cofrinho',
    'piggy-banks_show_piggyEvents'                                    => 'Todas as adições ou remoções também estão listadas aqui.',

    // bill index
    'bills_index_rules'                                               => 'Aqui você vê quais regras que vão verificar se esta assinatura bate',
    'bills_index_paid_in_period'                                      => 'Este campo indica quando a foi o último pagamento da assinatura.',
    'bills_index_expected_in_period'                                  => 'Este campo indica para cada assinatura se e quando a próxima assinatura a chegar é esperada.',

    'subscriptions_index_rules'                                       => 'Aqui você vê quais regras que vão verificar se esta assinatura bate',
    'subscriptions_index_paid_in_period'                              => 'Este campo indica quando a foi o último pagamento da assinatura.',
    'subscriptions_index_expected_in_period'                          => 'Este campo indica para cada assinatura se e quando a próxima assinatura a chegar é esperada.',

    // show bill
    'bills_show_billInfo'                                             => 'Esta tabela mostra algumas informações gerais sobre esta assinatura.',
    'bills_show_billButtons'                                          => 'Use este botão para verificar novamente transações antigas, então elas serão vinculadas a esta assinatura.',
    'bills_show_billChart'                                            => 'Este gráfico mostra as transações vinculadas a esta assinatura.',
    'subscriptions_show_billInfo'                                     => 'Esta tabela mostra algumas informações gerais sobre esta assinatura.',
    'subscriptions_show_billButtons'                                  => 'Use este botão para verificar novamente transações antigas, então elas serão vinculadas a esta assinatura.',
    'subscriptions_show_billChart'                                    => 'Este gráfico mostra as transações vinculadas a esta assinatura.',

    // create bill
    'bills_create_intro'                                              => 'Use as assinaturas para acompanhar a quantidade de dinheiro devido por período. Pense em gastos como aluguel, seguro ou pagamentos de hipoteca.',
    'bills_create_name'                                               => 'Use um nome descritivo como "Aluguel" ou "Plano de saúde".',
    // 'bills_create_match'                                      => 'To match transactions, use terms from those transactions or the expense account involved. All words must match.',
    'bills_create_amount_min_holder'                                  => 'Selecione um valor mínimo e máximo para esta assinatura.',
    'bills_create_repeat_freq_holder'                                 => 'A maioria das assinaturas repetem mensalmente, mas você pode definir outra frequência aqui.',
    'bills_create_skip_holder'                                        => 'Se uma assinatura se repete a cada 2 semanas, o campo "pular" deve ser definido como "1" para a repetição quinzenal.',

    // rules index
    'rules_index_intro'                                               => 'O Firefly III permite que você gerencie as regras, que serão automaticamente aplicadas a qualquer transação que você crie ou edite.',
    'rules_index_new_rule_group'                                      => 'Você pode criar grupos de regras para facilitar o gerenciamento.',
    'rules_index_new_rule'                                            => 'Crie quantas regras desejar.',
    'rules_index_prio_buttons'                                        => 'Você pode ordená-los da maneira que desejar.',
    'rules_index_test_buttons'                                        => 'Você pode testar suas regras ou aplicá-las em transações existentes.',
    'rules_index_rule-triggers'                                       => 'As regras têm "gatilhos" e "ações" que você pode ordenar apenas com funções de arrastar e soltar.',
    'rules_index_outro'                                               => 'Certifique-se de verificar as páginas de ajuda usando o ícone (?) No canto superior direito!',

    // create rule:
    'rules_create_mandatory'                                          => 'Escolha um título descritivo e configure quando a regra deve ser executada.',
    'rules_create_ruletriggerholder'                                  => 'Adicione tantos gatilhos quanto quiser, mas lembre-se de que TODOS os gatilhos devem ter correspondência antes que qualquer ação seja executada.',
    'rules_create_test_rule_triggers'                                 => 'Use este botão para ver quais transações combinariam com sua regra.',
    'rules_create_actions'                                            => 'Defina todas ações que desejar realizar.',



    // preferences
    'preferences_index_tabs'                                          => 'Mais opções estão disponíveis atrás dessas abas/guias.',

    // currencies
    'currencies_index_intro'                                          => 'Firefly III suporta múltiplas moedas, que você pode alterar nesta página.',
    'currencies_index_default'                                        => 'Firefly III tem uma moeda padrão.',
    'currencies_index_buttons'                                        => 'Use os botões para mudar a moeda padrão ou habilitar outras moedas.',

    // create currency
    'currencies_create_code'                                          => 'Este código deve ser compatível com a ISO (use o Google para achar o código da sua nova moeda).',
];
