<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


declare(strict_types=1);

return [
    'invalid_account_list' => 'Liste des types de comptes non valide',
    'limit_exists'                   => 'Il existe déjà une limite budgétaire (montant) pour ce budget et cette devise au cours de la période donnée.',
    'invalid_sort_instruction'       => 'L\'instruction de tri n\'est pas valide pour un objet de type «:object».',
    'invalid_sort_instruction_index' => 'L\'instruction de tri à l\'index n°:index n\'est pas valide pour un objet de type ":object".',
    'no_sort_instructions'           => 'Il n\'y a pas d\'instructions de tri définies pour un objet de type «:object».',
    'webhook_budget_info'            => 'Impossible de fournir des informations sur le budget pour les webhooks liés aux opérations.',
    'webhook_account_info'           => 'Impossible de fournir les informations du compte pour les webhooks liés au budget.',
    'webhook_transaction_info'       => 'Impossible de fournir des informations d\'opérations pour les webhooks liés au budget.',
    'invalid_account_type'           => 'Une tirelire ne peut être liée qu\'à des comptes d\'actifs et de passifs',
    'unique_currency_code' => 'Ce code de devise est déjà utilisé',
    'invalid_account_currency'       => 'Ce compte n\'utilise pas la devise que vous avez sélectionnée',
    'current_amount_too_much'        => 'Le montant combiné en "current_amount" ne peut pas dépasser "target_amount".',
    'filter_must_be_in'              => 'Le filtre « :filter » doit être parmi une des valeurs : :values',
    'filter_not_string'              => 'Le filtre « :filter » doit être une chaîne de caractères',
    'bad_api_filter'                 => 'Ce point de terminaison de l\'API ne supporte pas le filtre «:filter».',
    'nog_logged_in'                  => 'Vous n\'êtes pas connecté.',
    'prohibited'                     => 'Vous ne devez rien saisir dans le champ.',
    'bad_webhook_combination'        => 'Le déclencheur webhook «:trigger» ne peut pas être combiné avec la réponse du webhook «:response».',
    'unknown_webhook_trigger'        => 'Déclenchement webhook «:trigger» inconnu.',
    'only_any_trigger'               => 'Si vous sélectionnez le déclencheur "N\'importe quel événement", vous ne pouvez pas sélectionner d\'autres déclencheurs.',
    'bad_type_source'                => 'Firefly III ne peut pas déterminer le type de transaction basé sur ce compte source.',
    'bad_type_destination'           => 'Firefly III ne peut pas déterminer le type de transaction basé sur ce compte de destination.',
    'missing_where'                  => 'La requête ne contient pas de clause "where"',
    'missing_update'                 => 'La requête ne contient pas de clause "update"',
    'invalid_where_key'              => 'Le JSON contient une clé invalide pour la clause "where"',
    'invalid_update_key'             => 'Le JSON contient une clé invalide pour la clause "update"',
    'invalid_query_data'             => 'Il y a des données invalides dans le champ %s:%s de votre requête.',
    'invalid_query_account_type'     => 'Votre requête contient des comptes de différents types, ce qui n\'est pas autorisé.',
    'invalid_query_currency'         => 'Votre requête contient des comptes qui ont des paramètres de devise différents, ce qui n\'est pas autorisé.',
    'iban'                           => 'Il ne s\'agit pas d\'un IBAN valide.',
    'zero_or_more'                   => 'Le montant ne peut pas être négatif.',
    'more_than_zero'                 => 'La valeur doit être supérieure à zéro.',
    'more_than_zero_correct'         => 'La valeur doit être supérieure ou égale à zéro.',
    'no_asset_account'               => 'Ce n\'est pas un compte d\'actif.',
    'date_or_time'                   => 'La valeur doit être une date ou une heure valide (ISO 8601).',
    'source_equals_destination'      => 'Le compte source est identique au compte de destination.',
    'unique_account_number_for_user' => 'Il semble que ce numéro de compte soit déjà utilisé.',
    'unique_user_group_for_user'     => 'Il semble que ce titre d\'administration soit déjà utilisé.',
    'unique_iban_for_user'           => 'Il semble que cet IBAN soit déjà utilisé.',
    'reconciled_forbidden_field'     => 'Cette opération est déjà rappochée, vous ne pouvez pas modifier «:field»',
    'deleted_user'                   => 'Compte tenu des contraintes de sécurité, vous ne pouvez pas vous inscrire en utilisant cette adresse e-mail.',
    'rule_trigger_value'             => 'Cette valeur n’est pas valide pour le déclencheur sélectionné.',
    'rule_action_expression'         => 'Expression non valide. :error',
    'rule_action_value'              => 'Cette valeur n’est pas valide pour l’action sélectionnée.',
    'file_already_attached'          => 'Le fichier téléchargé ":name" est déjà attaché à cet objet.',
    'file_attached'                  => 'Fichier ":name" téléchargé avec succès.',
    'file_zero'                      => 'Le taille du fichier est de zéro octet.',
    'must_exist'                     => 'L\'ID dans le champ :attribute n\'existe pas dans la base de données.',
    'all_accounts_equal'             => 'Tous les comptes dans ce champ doivent être égaux.',
    'group_title_mandatory'          => 'Un titre de groupe est obligatoire lorsqu\'il y a plus d\'une opération.',
    'transaction_types_equal'        => 'Toutes les ventilations doivent être de même type.',
    'invalid_transaction_type'       => 'Type d\'opération non valide.',
    'invalid_selection'              => 'Votre sélection est invalide.',
    'belongs_user'                   => 'Cette valeur est liée à un objet qui ne semble pas exister.',
    'belongs_user_or_user_group'     => 'Cette valeur est liée à un objet qui ne semble pas exister dans votre administration financière actuelle.',
    'no_access_group'                => 'L\'utilisateur n\'a pas accès à cette administration.',
    'no_accepted_roles_defined'      => 'Aucun rôle d\'accès n\'a été défini pour ce point d\'accès, accès refusé.',
    'at_least_one_transaction'       => 'Besoin d\'au moins une opération.',
    'recurring_transaction_id'       => 'Au moins une opération est nécessaire.',
    'need_id_to_match'               => 'Vous devez saisir cette entrée avec un identifiant pour que l\'API puisse la faire correspondre.',
    'too_many_unmatched'             => 'Trop d\'opérations saisies ne peuvent être associées à leurs entrées respectives dans la base de données. Assurez-vous que les entrées existantes ont un identifiant valide.',
    'id_does_not_match'              => 'L\'identifiant #:id saisi ne correspond pas à l\'identifiant attendu. Assurez-vous qu\'il correspond ou omettez le champ.',
    'at_least_one_repetition'        => 'Besoin d\'au moins une répétition.',
    'require_repeat_until'           => 'Besoin d’un certain nombre de répétitions ou d\'une date de fin (repeat_until). Pas les deux.',
    'require_currency_info'          => 'Le contenu de ce champ n\'est pas valide sans informations sur la devise.',
    'require_currency_id_code'       => 'Veuillez définir soit "transaction_currency_id" soit "transaction_currency_code".',
    'not_transfer_account'           => 'Ce compte n\'est pas un compte qui peut être utilisé pour les transferts.',
    'require_currency_amount'        => 'Le contenu de ce champ est invalide sans informations sur le montant en devise étrangère.',
    'require_foreign_currency'       => 'Ce champ doit être un nombre',
    'require_foreign_dest'           => 'Ce champ doit correspondre à la devise du compte de destination.',
    'require_foreign_src'            => 'Ce champ doit correspondre à la devise du compte source.',
    'equal_description'              => 'La description de l\'opération ne doit pas être identique à la description globale.',
    'file_invalid_mime'              => 'Le fichier ":name" est du type ":mime" ce qui n\'est pas accepté pour un nouvel envoi.',
    'file_too_large'                 => 'Le fichier ":name" est trop grand.',
    'belongs_to_user'                => 'La valeur de :attribute est inconnue.',
    'accepted'                       => 'Le champ :attribute doit être accepté.',
    'bic'                            => 'Ce n’est pas un code BIC valide.',
    'at_least_one_trigger'           => 'Une règle doit avoir au moins un déclencheur.',
    'at_least_one_active_trigger'    => 'Une règle doit avoir au moins un déclencheur.',
    'at_least_one_action'            => 'Une règle doit avoir au moins une action.',
    'at_least_one_active_action'     => 'La règle doit avoir au moins une action active.',
    'base64'                         => 'Il ne s\'agit pas de données base64 valides.',
    'model_id_invalid'               => 'L’ID fournit ne semble pas valide pour ce modèle.',
    'less'                           => ':attribute doit être inférieur à 10 000 000',
    'active_url'                     => 'Le champ :attribute n\'est pas une URL valide.',
    'after'                          => 'Le champ :attribute doit être une date postérieure à :date.',
    'date_after'                     => 'La date de début doit être antérieure à la date de fin.',
    'alpha'                          => 'Le champ :attribute doit seulement contenir des lettres.',
    'alpha_dash'                     => 'Le champ :attribute peut seulement contenir des lettres, des chiffres et des tirets.',
    'alpha_num'                      => 'Le champ :attribute peut seulement contenir des chiffres et des lettres.',
    'array'                          => 'Le champ :attribute doit être un tableau.',
    'unique_for_user'                => 'Il existe déjà une entrée avec ceci :attribute.',
    'before'                         => 'Le champ :attribute doit être une date antérieure à :date.',
    'unique_object_for_user'         => 'Ce nom est déjà utilisé.',
    'unique_account_for_user'        => 'Ce nom de compte est déjà utilisé.',


    'between.numeric'            => 'La valeur de :attribute doit être comprise entre :min et :max.',
    'between.file'               => 'Le fichier :attribute doit avoir une taille entre :min et :max kilo-octets.',
    'between.string'             => 'Le texte :attribute doit avoir entre :min et :max caractères.',
    'between.array'              => 'Le tableau :attribute doit avoir entre :min et :max éléments.',
    'between_date'               => 'La date doit être comprise entre la date de début et la date de fin.',
    'boolean'                    => 'Le champ :attribute doit être vrai ou faux.',
    'confirmed'                  => 'Le champ de confirmation :attribute ne correspond pas.',
    'date'                       => 'Le champ :attribute n\'est pas une date valide.',
    'date_format'                => 'Le champ :attribute ne correspond pas au format :format.',
    'different'                  => 'Les champs :attribute et :other doivent être différents.',
    'digits'                     => 'Le champ :attribute doit avoir :digits chiffres.',
    'digits_between'             => 'Le champ :attribute doit avoir entre :min et :max chiffres.',
    'email'                      => 'Le champ :attribute doit être une adresse email valide.',
    'filled'                     => 'Le champ :attribute est obligatoire.',
    'exists'                     => 'Le champ :attribute sélectionné est invalide.',
    'image'                      => 'Le champ :attribute doit être une image.',
    'in'                         => 'Le champ :attribute est invalide.',
    'integer'                    => 'Le champ :attribute doit être un entier.',
    'ip'                         => 'Le champ :attribute doit être une adresse IP valide.',
    'json'                       => 'Le champ :attribute doit être un document JSON valide.',
    'max.numeric'                => 'La valeur de :attribute ne peut être supérieure à :max.',
    'max.file'                   => 'Le fichier :attribute ne peut être plus gros que :max kilo-octets.',
    'max.string'                 => 'Le texte de :attribute ne peut contenir plus de :max caractères.',
    'max.array'                  => 'Le tableau :attribute ne peut avoir plus de :max éléments.',
    'mimes'                      => 'Le champ :attribute doit être un fichier de type : :values.',
    'min.numeric'                => 'La valeur de :attribute doit être supérieure à :min.',
    'lte.numeric'                => ':attribute doit être inférieur ou égal à :value.',
    'min.file'                   => 'Le fichier :attribute doit être plus gros que :min kilo-octets.',
    'min.string'                 => 'Le texte :attribute doit contenir au moins :min caractères.',
    'min.array'                  => 'Le tableau :attribute doit avoir au moins :min éléments.',
    'not_in'                     => 'Le champ :attribute sélectionné n\'est pas valide.',
    'numeric'                    => 'Le champ :attribute doit contenir un nombre.',
    'convert_to_itself'          => 'Impossible de stocker le taux de change pour «:code», car les devises source et cible sont les mêmes.',
    'invalid_currency_code'      => 'Le code de la devise «:code» est invalide',
    'scientific_notation'        => 'Le champ :attribute ne peut pas utiliser la notation scientifique.',
    'numeric_primary'            => 'Le montant en devise principale doit être un nombre.',
    'numeric_destination'        => 'Le montant de destination doit être un nombre.',
    'numeric_source'             => 'Le montant source doit être un nombre.',
    'generic_invalid'            => 'Cette valeur n\'est pas valide.',
    'transaction_type_changed'   => 'Si vous modifiez le type de l\'opération, assurez-vous que les comptes source/destination corrects sont définis.',
    'regex'                      => 'Le format du champ :attribute est invalide.',
    'required'                   => 'Le champ :attribute est obligatoire.',
    'required_if'                => 'Le champ :attribute est obligatoire quand la valeur de :other est :value.',
    'required_unless'            => 'Le champ :attribute est obligatoire sauf si :other est :values.',
    'required_with'              => 'Le champ :attribute est obligatoire quand :values est présent.',
    'required_with_all'          => 'Le champ :attribute est obligatoire quand :values est présent.',
    'required_without'           => 'Le champ :attribute est obligatoire quand :values n\'est pas présent.',
    'required_without_all'       => 'Le champ :attribute est requis quand aucun de :values n\'est présent.',
    'same'                       => 'Les champs :attribute et :other doivent être identiques.',
    'size.numeric'               => 'La valeur de :attribute doit être :size.',
    'amount_min_over_max'        => 'Le montant minimum ne peut pas être supérieur au montant maximum.',
    'size.file'                  => 'La taille du fichier de :attribute doit être de :size kilo-octets.',
    'size.string'                => 'Le texte de :attribute doit contenir :size caractères.',
    'size.array'                 => 'Le tableau :attribute doit contenir :size éléments.',
    'unique'                     => 'La valeur du champ :attribute est déjà utilisée.',
    'string'                     => 'Le champ :attribute doit être une chaîne de caractères.',
    'url'                        => 'Le format de l\'URL de :attribute n\'est pas valide.',
    'timezone'                   => 'Le champ :attribute doit être un fuseau horaire valide.',
    '2fa_code'                   => 'Le champ :attribute est invalide.',
    'dimensions'                 => 'Le :attribute possède des dimensions d’image non valides.',
    'distinct'                   => ':attribute possède une valeur en double.',
    'file'                       => 'Le :attribute doit être un fichier.',
    'in_array'                   => 'Le champ :attribute n\'existe pas dans :other.',
    'present'                    => 'Le champs :attribute doit être rempli.',
    'amount_zero'                => 'Le montant total ne peut pas être zéro.',
    'current_target_amount'      => 'Le montant actuel doit être inférieur au montant cible.',
    'unique_piggy_bank_for_user' => 'Le nom de la tirelire doit être unique.',
    'unique_object_group'        => 'Le nom du groupe doit être unique',
    'starts_with'                => 'La valeur doit commencer par :values.',
    'unique_webhook'             => 'Vous avez déjà un webhook avec cette combinaison d\'URL, de déclencheur, de réponse et de livraison.',
    'unique_existing_webhook'    => 'Vous avez déjà un autre webhook avec cette combinaison d\'URL, de déclencheur, de réponse et de livraison.',
    'same_account_type'          => 'Les deux comptes doivent être du même type',
    'same_account_currency'      => 'Les deux comptes doivent avoir la même devise',
    'piggy_no_change_currency'   => 'Comme il y a des tirelires liés à ce compte, vous ne pouvez pas changer la devise du compte.',


    'secure_password'             => 'Ce mot de passe n\'est pas sécurisé. Veuillez réessayer. Pour plus d\'informations, visitez le site https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'   => 'Type de répétition non valide pour des opérations périodiques.',
    'valid_recurrence_rep_moment' => 'Période de répétition non valide pour ce type de répétition.',
    'invalid_account_info'        => 'Informations de compte non valides.',
    'attributes'                  => [
        'email'                   => 'adresse email',
        'description'             => 'description',
        'amount'                  => 'montant',
        'transactions.*.amount'   => 'montant de l\'opération',
        'name'                    => 'nom',
        'piggy_bank_id'           => 'ID de tirelire',
        'targetamount'            => 'montant cible',
        'opening_balance_date'    => 'date du solde initial',
        'opening_balance'         => 'solde initial',
        'match'                   => 'correspondance',
        'amount_min'              => 'montant minimum',
        'amount_max'              => 'montant maximum',
        'title'                   => 'titre',
        'tag'                     => 'tag',
        'transaction_description' => 'description de l\'opération',
        'rule-action-value.1'     => 'valeur d\'action de la règle #1',
        'rule-action-value.2'     => 'valeur d\'action de la règle #2',
        'rule-action-value.3'     => 'valeur d\'action de la règle #3',
        'rule-action-value.4'     => 'valeur d\'action de la règle #4',
        'rule-action-value.5'     => 'valeur d\'action de la règle #5',
        'rule-action.1'           => 'action de règle #1',
        'rule-action.2'           => 'action de règle #2',
        'rule-action.3'           => 'action de règle #3',
        'rule-action.4'           => 'action de règle #4',
        'rule-action.5'           => 'action de règle #5',
        'rule-trigger-value.1'    => 'valeur seuil de déclenchement de la règle #1',
        'rule-trigger-value.2'    => 'valeur seuil de déclenchement de la règle #2',
        'rule-trigger-value.3'    => 'valeur seuil de déclenchement de la règle #3',
        'rule-trigger-value.4'    => 'valeur seuil de déclenchement de la règle #4',
        'rule-trigger-value.5'    => 'valeur seuil de déclenchement de la règle #5',
        'rule-trigger.1'          => 'déclencheur de règle #1',
        'rule-trigger.2'          => 'déclencheur de règle #2',
        'rule-trigger.3'          => 'déclencheur de règle #3',
        'rule-trigger.4'          => 'déclencheur de règle #4',
        'rule-trigger.5'          => 'déclencheur de règle #4',
    ],

    // validation of accounts:
    'withdrawal_source_need_data' => 'Vous devez obtenir un ID de compte source valide et/ou un nom de compte source valide pour continuer.',
    'withdrawal_source_bad_data'  => '[a] Impossible de trouver un compte source valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'withdrawal_dest_need_data'   => '[a] Vous devez obtenir un ID de compte de destination valide et/ou un nom de compte de destination valide pour continuer.',
    'withdrawal_dest_bad_data'    => 'Impossible de trouver un compte de destination valide lors de la recherche de l\'ID ":id" ou du nom ":name".',

    'withdrawal_dest_iban_exists' => 'Cet IBAN de compte de destination est déjà utilisé par un compte d\'actif ou un passif et ne peut pas être utilisé comme destination de dépense.',
    'deposit_src_iban_exists'     => 'Cet IBAN de compte source est déjà utilisé par un compte d\'actif ou un passif et ne peut pas être utilisé comme source de dépôt.',

    'reconciliation_source_bad_data' => 'Impossible de trouver un compte de rapprochement valide lors de la recherche de l\'ID ":id" ou du nom ":name".',

    'generic_source_bad_data' => '[e] Impossible de trouver un compte source valide lors de la recherche de l\'ID ":id" ou du nom ":name".',

    'deposit_source_need_data' => 'Vous devez obtenir un ID de compte source valide et/ou un nom de compte source valide pour continuer.',
    'deposit_source_bad_data'  => '[b] Impossible de trouver un compte source valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'deposit_dest_need_data'   => '[b] Vous devez obtenir un ID de compte de destination valide et/ou un nom de compte de destination valide pour continuer.',
    'deposit_dest_bad_data'    => 'Impossible de trouver un compte de destination valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'deposit_dest_wrong_type'  => 'Le compte de destination saisi n\'est pas du bon type.',


    'transfer_source_need_data' => 'Vous devez obtenir un ID de compte source valide et/ou un nom de compte source valide pour continuer.',
    'transfer_source_bad_data'  => '[c] Impossible de trouver un compte source valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'transfer_dest_need_data'   => '[c] Vous devez obtenir un ID de compte de destination valide et/ou un nom de compte de destination valide pour continuer.',
    'transfer_dest_bad_data'    => 'Impossible de trouver un compte de destination valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'need_id_in_edit'           => 'Chaque ventilation doit avoir transaction_journal_id (ID valide ou 0).',

    'ob_source_need_data'           => 'Vous devez obtenir un ID de compte source valide et/ou un nom de compte source valide pour continuer.',
    'lc_source_need_data'           => 'Besoin d\'un identifiant de compte source valide pour continuer.',
    'ob_dest_need_data'             => '[d] Vous devez obtenir un ID de compte de destination valide et/ou un nom de compte de destination valide pour continuer.',
    'ob_dest_bad_data'              => 'Impossible de trouver un compte de destination valide lors de la recherche de l\'ID ":id" ou du nom ":name".',
    'reconciliation_either_account' => 'Pour soumettre un rapprochement, vous devez soumettre soit une source soit un compte de destination. Ni les deux, ni aucun.',

    'generic_invalid_source'      => 'Vous ne pouvez pas utiliser ce compte comme compte source.',
    'generic_invalid_destination' => 'Vous ne pouvez pas utiliser ce compte comme compte de destination.',

    'generic_no_source'      => 'Vous devez saisir les informations du compte source ou saisir un ID de journal d\'opération.',
    'generic_no_destination' => 'Vous devez saisir les informations du compte destination ou saisir un ID de journal d\'opération.',

    'gte.numeric'  => 'La valeur de :attribute doit être supérieure ou égale à :value.',
    'gt.numeric'   => 'Le champ :attribute doit être plus grand que :value.',
    'gte.file'     => 'L\'attribut :attribute doit contenir au moins :value kilo-octets.',
    'gte.string'   => 'Le texte :attribute doit contenir au moins :value caractères.',
    'gte.array'    => 'L\'attribut :attribute doit avoir :value éléments ou plus.',
    'missing_with' => ':attribute ne peut pas être combiné avec un autre champ.',

    'amount_required_for_auto_budget' => 'Le montant est requis.',
    'auto_budget_amount_positive'     => 'Le montant doit être supérieur à zéro.',

    'auto_budget_period_mandatory' => 'La période du budget automatique est un champ obligatoire.',

    // no access to administration:
    'no_auth_user_group'           => 'Vous devez être connecté pour accéder à cette administration.',
    'no_access_user_group'         => 'Vous n\'avez pas les droits d\'accès corrects pour cette administration.',
    'administration_owner_rename'  => 'Vous ne pouvez pas renommer votre administration financière standard.',
    'existing_mfa_code'            => 'Veuillez saisir un code valide',
];
