<?php

/**
 * email.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // common items
    'greeting'                                    => 'Γεια σου,',
    'closing'                                     => 'Μπιπ μπιπ,',
    'signature'                                   => 'Το Ρομπότ Αλληλογραφίας του Firefly III',
    'footer_ps'                                   => 'ΥΓ: Αυτό το μήνυμα στάλθηκε επειδή μια αίτηση από την IP :ipAddress το ενεργοποίησε.',

    // admin test
    'admin_test_subject'                          => 'Ένα δοκιμαστικό μήνυμα από την εγκατάσταση του Firefly III',
    'admin_test_body'                             => 'Αυτό είναι ένα δοκιμαστικό μήνυμα από την εγκατάσταση του Firefly III. Αποστάλθηκε στο :email.',
    'admin_test_message'                          => 'This is a test message from your Firefly III instance over channel ":channel".',



    // invite
    'invitation_created_subject'                  => 'Έχει δημιουργηθεί μια πρόσκληση',
    'invitation_created_body'                     => 'Admin user ":email" created a user invitation which can be used by whoever is behind email address ":invitee". The invite will be valid for 48hrs.',
    'invite_user_subject'                         => 'You\'ve been invited to create a Firefly III account.',
    'invitation_introduction'                     => 'You\'ve been invited to create a Firefly III account on **:host**. Firefly III  is a personal, self-hosted, private personal finance manager. All the cool kids are using it.',
    'invitation_invited_by'                       => 'You\'ve been invited by ":admin" and this invitation was sent to ":invitee". That\'s you, right?',
    'invitation_url'                              => 'The invitation is valid for 48 hours and can be redeemed by surfing to [Firefly III](:url). Enjoy!',

    // new IP
    'login_from_new_ip'                           => 'Νέα σύνδεση χρήστη στο Firefly III',
    'slack_login_from_new_ip'                     => 'New Firefly III login from IP :ip (:host)',
    'new_ip_body'                                 => 'Το Firefly III εντόπισε μια νέα σύνδεση στο λογαριασμό σας από μια άγνωστη διεύθυνση IP. Αν δεν συνδεθήκατε ποτέ από την παρακάτω διεύθυνση IP ή έγινε πριν από περισσότερο από έξι μήνες, το Firefly III θα σας προειδοποιήσει.',
    'new_ip_warning'                              => 'Αν αναγνωρίζετε αυτή τη διεύθυνση IP ή τη σύνδεση χρήστη, μπορείτε να αγνοήσετε αυτό το μήνυμα. Αν δεν συνδεθήκατε, αν δεν έχετε ιδέα για το τι είναι αυτό, επαληθεύστε ένα ασφαλή κωδικό πρόσβασης, αλλάξτε τον και αποσυνδεθείτε από όλες τις άλλες συνεδρίες. Για να το κάνετε αυτό, πηγαίνετε στη σελίδα του προφίλ σας. Φυσικά έχετε ήδη ενεργοποιημένο το 2FactorAuthentication, έτσι? Μείνετε ασφαλείς!',
    'ip_address'                                  => 'Διεύθυνση IP',
    'host_name'                                   => 'Διακομιστής',
    'date_time'                                   => 'Ημερομηνία και ώρα',
    'user_agent'                                  => 'Browser',

    // access token created
    'access_token_created_subject'                => 'Δημιουργήθηκε ένα νέο διακριτικό πρόσβασης',
    'access_token_created_body'                   => 'Κάποιος (ελπίζω εσείς) μόλις δημιούργησε ένα νέο Διακριτικό Πρόσβασης Firefly III API για το δικό σας λογαριασμό χρήστη.',
    'access_token_created_explanation'            => 'With this token, they can access **all** of your financial records through the Firefly III API.',
    'access_token_created_revoke'                 => 'If this wasn\'t you, please revoke this token as soon as possible at :url',

    // unknown user login attempt
    'unknown_user_subject'                        => 'An unknown user tried to log in',
    'unknown_user_body'                           => 'An unknown user (:ip) tried to log in to Firefly III. The email address they used was ":address".',
    'unknown_user_message'                        => 'The email address they (:ip) used was ":address".',

    // known user login attempt
    'failed_login_subject'                        => 'Firefly III detected a failed login attempt',
    'failed_login_body'                           => 'Firefly III detected that somebody (you?) failed to login with your account ":email". Please verify that this was you.',
    'failed_login_message'                        => 'A failed login attempt (:ip) on your Firefly III account ":email" was detected.',
    'failed_login_warning'                        => 'If you recognize this IP address or the login attempt, you can ignore this message. If you didn\'t try to login, of if you have no idea what this is about, verify your password security, change it, and log out all other sessions. To do this, go to your profile page. Of course you have 2FA enabled already, right? Stay safe!',

    // registered
    'registered_subject'                          => 'Καλωσήρθατε στο Firefly III!',
    'registered_subject_admin'                    => 'A new user has registered',
    'admin_new_user_registered'                   => 'A new user has registered. User **:email** was given user ID #:id.',
    'registered_welcome'                          => 'Welcome to [Firefly III](:address). Your registration has made it, and this email is here to confirm it. Yay!',
    'registered_pw'                               => 'If you have forgotten your password already, please reset it using [the password reset tool](:address/password/reset).',
    'registered_help'                             => 'Υπάρχει ένα εικονίδιο βοήθειας στην επάνω δεξιά γωνία κάθε σελίδας. Αν χρειάζεστε βοήθεια, κάντε κλικ σε αυτό!',
    'registered_closing'                          => 'Καλή Διασκέδαση!',
    'registered_firefly_iii_link'                 => 'Firefly III:',
    'registered_pw_reset_link'                    => 'Επαναφορά κωδικού πρόσβασης:',
    'registered_doc_link'                         => 'Τεκμηρίωση:',



    // new version
    'new_version_email_subject'                   => 'Μια νέα έκδοση του Firefly III είναι διαθέσιμη',

    // email change
    'email_change_subject'                        => 'Η διεύθυνση email σας στο Firefly III έχει αλλάξει',
    'email_change_body_to_new'                    => 'Εσείς ή κάποιος με πρόσβαση στο λογαριασμό σας στο Firefly III έχει αλλάξει τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας. Αν δεν περιμένατε αυτό το μήνυμα, παρακαλώ αγνοήστε και διαγράψτε το.',
    'email_change_body_to_old'                    => 'You or somebody with access to your Firefly III account has changed your email address. If you did not expect this to happen, you **must** follow the "undo"-link below to protect your account!',
    'email_change_ignore'                         => 'Αν ξεκινήσατε αυτήν την αλλαγή, μπορείτε να αγνοήσετε με ασφάλεια αυτό το μήνυμα.',
    'email_change_old'                            => 'Η παλιά διεύθυνση ηλεκτρονικού ταχυδρομείου ήταν: :email',
    'email_change_old_strong'                     => 'Η παλιά διεύθυνση ηλεκτρονικού ταχυδρομείου ήταν: **:email**',
    'email_change_new'                            => 'Η νέα διεύθυνση ηλεκτρονικού ταχυδρομείου είναι: :email',
    'email_change_new_strong'                     => 'Η νέα διεύθυνση ηλεκτρονικού ταχυδρομείου είναι: **:email**',
    'email_change_instructions'                   => 'Δεν μπορείτε να χρησιμοποιήσετε το Firefly III μέχρι να επιβεβαιώσετε αυτήν την αλλαγή. Ακολουθήστε τον παρακάτω σύνδεσμο για να το κάνετε.',
    'email_change_undo_link'                      => 'Για να αναιρέσετε την αλλαγή, ακολουθήστε αυτόν τον σύνδεσμο:',

    // OAuth token created
    'oauth_created_subject'                       => 'Δημιουργήθηκε ένας νέος πελάτης OAuth',
    'oauth_created_body'                          => 'Somebody (hopefully you) just created a new Firefly III API OAuth Client for your user account. It\'s labeled ":name" and has callback URL `:url`.',
    'oauth_created_explanation'                   => 'With this client, they can access **all** of your financial records through the Firefly III API.',
    'oauth_created_undo'                          => 'If this wasn\'t you, please revoke this client as soon as possible at `:url`',

    // reset password
    'reset_pw_subject'                            => 'Αίτημα επαναφοράς κωδικού πρόσβασης',
    'reset_pw_message'                            => 'You have received password reset instructions in your email. If this was you, please follow the instructions.',
    'reset_pw_instructions'                       => 'Κάποιος θέλει να κάνει επαναφορά για τον κωδικό πρόσβασής σας. Αν ήσασταν εσείς, παρακαλούμε ακολουθήστε τον παρακάτω σύνδεσμο για να το κάνετε.',
    'reset_pw_warning'                            => '**PLEASE** verify that the link actually goes to the Firefly III you expect it to go!',

    // error
    'error_subject'                               => 'Βρέθηκε ένα σφάλμα στο Firefly III',
    'error_intro'                                 => 'Το Firefly III v:version συνάντησε ένα σφάλμα: <span style="font-family: monospace;">:errorMessage</span>.',
    'error_type'                                  => 'Το σφάλμα ήταν του τύπου ":class".',
    'error_timestamp'                             => 'Το σφάλμα προέκυψε την/στις: :time.',
    'error_location'                              => 'Αυτό το σφάλμα προέκυψε στο αρχείο "<span style="font-family: monospace;">:file</span>" στη γραμμή :line με τον κωδικό :code.',
    'error_user'                                  => 'Το σφάλμα προέκυψε στο χρήστη #:id, <a href="mailto::email">:email</a>.',
    'error_no_user'                               => 'Δεν υπήρξε κανένας συνδεδεμένος χρήστης για αυτό το σφάλμα ή κανένας χρήστης δεν εντοπίστηκε.',
    'error_ip'                                    => 'Η διεύθυνση IP που σχετίζεται με αυτό το σφάλμα είναι: :ip',
    'error_url'                                   => 'Το URL είναι: :url',
    'error_user_agent'                            => 'User agent: :userAgent',
    'error_stacktrace'                            => 'The full stacktrace is below. If you think this is a bug in Firefly III, you can forward this message to <a href="mailto:james@firefly-iii.org?subject=I%20found%20a%20bug!">james@firefly-iii.org</a>. This can help fix the bug you just encountered.',
    'error_github_html'                           => 'Αν προτιμάτε, μπορείτε επίσης να ανοίξετε ένα νέο ζήτημα στο <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a>.',
    'error_github_text'                           => 'Αν προτιμάτε, μπορείτε επίσης να ανοίξετε ένα νέο ζήτημα στο https://github.com/firefly-iii/firefly-iii/issues.',
    'error_stacktrace_below'                      => 'Το πλήρες stacktrace είναι παρακάτω:',
    'error_headers'                               => 'The following headers may also be relevant:',
    'error_post'                                  => 'This was submitted by the user:',



    // report new journals
    'new_journals_subject'                        => 'Το Firefly III έχει δημιουργήσει μια νέα συναλλαγή|Το Firefly III έχει δημιουργήσει :count νέες συναλλαγές',
    'new_journals_header'                         => 'Το Firefly III έχει δημιουργήσει μια συναλλαγή για εσάς. Μπορείτε να τη βρείτε στην εγκατάσταση Firefly ΙΙΙ:|Το Firefly III έχει δημιουργήσει :count συναλλαγές για εσάς. Μπορείτε να τις βρείτε στην εγκατάσταση Firefly III:',

    // subscription is overdue.
    'subscriptions_overdue_subject_multi'               => 'You have :count subscriptions that are overdue to be paid',
    'subscriptions_overdue_subject_single'               => 'You have a subscription that is overdue to be paid',
    'subscriptions_overdue_warning_intro_single' => 'You have one subscription that is overdue to be paid. At the following date(s) a payment was expected, but it has not yet arrived.',
    'subscriptions_overdue_warning_intro_multi' => 'You have :count subscription(s) that are overdue to be paid. At the following date(s) a payment was expected, but it has not yet arrived.',
    'subscriptions_overdue_please_action_single' => 'Perhaps you have simply not linked a transaction to this subscription. In that case, please do so. You will NOT get another warning about this overdue subscription. A new warning will be sent out for the NEXT due payment.',
    'subscriptions_overdue_please_action_multi' => 'Perhaps you have simply not linked a transaction to these subscriptions. In that case, please do so. You will NOT get another warning about these overdue subscriptions. A new warning will be sent out for the NEXT due payments.',
    'subscriptions_overdue_outro' => 'If you believe this message is wrong, please contact the Firefly III developer. Thank you for using Firefly III.',
    // bill warning
    'bill_warning_subject_end_date'               => 'Your subscription ":name" is due to end in :diff days',
    'bill_warning_subject_now_end_date'           => 'Your subscription ":name" is due to end TODAY',
    'bill_warning_subject_extension_date'         => 'Your subscription ":name" is due to be extended or cancelled in :diff days',
    'bill_warning_subject_now_extension_date'     => 'Your subscription ":name" is due to be extended or cancelled TODAY',
    'bill_warning_end_date'                       => 'Your subscription **":name"** is due to end on :date. This moment will pass in about **:diff days**.',
    'bill_warning_extension_date'                 => 'Your subscription **":name"** is due to be extended or cancelled on :date. This moment will pass in about **:diff days**.',
    'bill_warning_end_date_zero'                  => 'Your subscription **":name"** is due to end on :date. This moment will pass **TODAY!**',
    'bill_warning_extension_date_zero'            => 'Your subscription **":name"** is due to be extended or cancelled on :date. This moment will pass **TODAY!**',
    'bill_warning_please_action'                  => 'Please take the appropriate action.',

    // user has enabled MFA
    'enabled_mfa_subject'                         => 'You have enabled multi-factor authentication',
    'enabled_mfa_slack'                           => 'You (:email) have enabled multi-factor authentication. Is this not correct? Check your settings!',
    'have_enabled_mfa'                            => 'You have enabled multi-factor authentication on your Firefly III account ":email". This means that you will need to use an authenticator app to log in from now on.',
    'enabled_mfa_warning'                         => 'If you did not enable this, please contact your administrator immediately or check out the Firefly III documentation.',

    'disabled_mfa_subject'                        => 'You have disabled multi-factor authentication!',
    'disabled_mfa_slack'                          => 'You (:email) have disabled multi-factor authentication. Is this not correct? Check your settings!',
    'have_disabled_mfa'                           => 'You have disabled multi-factor authentication on your Firefly III account ":email".',
    'disabled_mfa_warning'                        => 'If you did not disable this, please contact your administrator immediately or check out the Firefly III documentation.',

    'new_backup_codes_subject'                    => 'You have generated new back-up codes',
    'new_backup_codes_slack'                      => 'You (:email) have generated new back-up codes. These can be used to login to Firefly III. Is this not correct? Check your settings!',
    'new_backup_codes_intro'                      => 'You (:email) have generated new back-up codes. These can be used to login to Firefly III if you lose access to your authenticator app.',
    'new_backup_codes_warning'                    => 'Please store these codes in a safe place. If you lose them, you will not be able to log in to Firefly III. If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

    'used_backup_code_subject'                    => 'You have used a back-up code to login',
    'used_backup_code_slack'                      => 'You (:email) have used a back-up code to login',

    'used_backup_code_intro'                      => 'You (:email) have used a back-up code to login to Firefly III. You now have one less back-up code to login with. Please remove it from your list.',
    'used_backup_code_warning'                    => 'If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

    // few left:
    'mfa_few_backups_left_subject'                => 'You have only :count backup code(s) left!',
    'mfa_few_backups_left_slack'                  => 'You (:email) have only :count backup code(s) left!',
    'few_backup_codes_intro'                      => 'You (:email) have used most of your backup codes, and now have only :count left. Please generate new ones as soon as possible.',
    'few_backup_codes_warning'                    => 'Without backup codes, you cannot recover your MFA login if you lose access to your code generator.',

    // NO left:
    'mfa_no_backups_left_subject'                 => 'You have NO backup codes left!',
    'mfa_no_backups_left_slack'                   => 'You (:email) NO backup codes left!',
    'no_backup_codes_intro'                       => 'You (:email) have used ALL of your backup codes. Please generate new ones as soon as possible.',
    'no_backup_codes_warning'                     => 'Without backup codes, you cannot recover your MFA login if you lose access to your code generator.',

    // many failed MFA attempts
    'mfa_many_failed_subject'                     => 'You have tried and failed to use multi-factor authentication :count times now!',
    'mfa_many_failed_slack'                       => 'You (:email) have tried and failed to use multi-factor authentication :count times now. Is this not correct? Check your settings!',
    'mfa_many_failed_attempts_intro'              => 'You (:email) have tried :count times to use a multi-factor authentication code, but these login attempts have failed. Are you sure you are using the right MFA code? Are you sure the time on the server is correct?',
    'mfa_many_failed_attempts_warning'            => 'If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

];
