<?php

/*
 * AccountBalance.php
 * Copyright (c) 2024 james@firefly-iii.org.
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see https://www.gnu.org/licenses/.
 */

declare(strict_types=1);

namespace FireflyIII\Entities;

use FireflyIII\Models\Account;

class AccountBalance
{
    public string $amount;
    public string $currencyId;
    public string $id;

    public static function fromArray(): self
    {
        $balance             = new self();
        $balance->id         = (string) random_int(1, 1000);
        // $balance->name       = (string) random_int(1, 1000);
        $balance->amount     = (string) random_int(1, 1000);
        $balance->currencyId = '1';

        return $balance;
    }

    public function getAccount(): Account
    {
        return Account::inRandomOrder()->first();
    }
}
