/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.htsget;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.htsget.HtsgetClass;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetMalformedResponseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mjson.Json;

public class HtsgetResponse {
    private final HtsgetFormat format;
    private final List<Block> blocks;
    private final String md5;

    public HtsgetResponse(HtsgetFormat format, List<Block> blocks, String md5) {
        this.format = format;
        this.blocks = blocks;
        this.md5 = md5;
    }

    public HtsgetFormat getFormat() {
        return this.format;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public String getMd5() {
        return this.md5;
    }

    public static HtsgetResponse parse(String s) {
        Json j = Json.read((String)s);
        Json htsget = j.at("htsget");
        if (htsget == null) {
            throw new HtsgetMalformedResponseException("No htsget key found in response");
        }
        Json md5Json = htsget.at("md5");
        Json formatJson = htsget.at("format");
        Json blocksJson = htsget.at("urls");
        if (blocksJson == null) {
            throw new HtsgetMalformedResponseException("No urls field found in Htsget Response");
        }
        List<Block> blocks = blocksJson.asJsonList().stream().map(Block::parse).collect(Collectors.toList());
        return new HtsgetResponse(formatJson == null ? null : HtsgetFormat.valueOf(formatJson.asString().toUpperCase()), blocks, md5Json == null ? null : md5Json.asString());
    }

    public InputStream getDataStream() {
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private final Iterator<Block> iterator;
            {
                this.iterator = HtsgetResponse.this.blocks.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return this.iterator.next().getData();
            }
        });
    }

    public static class Block {
        private final URI uri;
        private final Map<String, String> headers;
        private final HtsgetClass dataClass;

        public Block(URI uri, Map<String, String> headers, HtsgetClass dataClass) {
            this.uri = uri;
            this.headers = headers;
            this.dataClass = dataClass;
        }

        public URI getUri() {
            return this.uri;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public HtsgetClass getDataClass() {
            return this.dataClass;
        }

        public InputStream getData() {
            switch (this.getUri().getScheme()) {
                case "http": 
                case "https": {
                    try {
                        HttpURLConnection conn = (HttpURLConnection)this.uri.toURL().openConnection();
                        conn.setRequestMethod("GET");
                        this.headers.forEach(conn::setRequestProperty);
                        conn.connect();
                        return conn.getInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Could not retrieve data from block", e);
                    }
                }
                case "data": {
                    String dataUri = this.uri.toString();
                    if (!dataUri.matches("^data:.*;base64,.*")) {
                        throw new HtsgetMalformedResponseException("data URI must be base64 encoded: " + dataUri);
                    }
                    return new ByteArrayInputStream(Base64.getDecoder().decode(dataUri.replaceFirst("^data:.*;base64,", "")));
                }
            }
            throw new HtsgetMalformedResponseException("Unrecognized URI scheme in data block: " + this.uri.getScheme());
        }

        public static Block parse(Json blockJson) {
            URI uri;
            Json uriJson = blockJson.at("url");
            if (uriJson == null) {
                throw new HtsgetMalformedResponseException("No URI found in Htsget data block: " + blockJson.toString().substring(0, Math.min(100, blockJson.toString().length())));
            }
            try {
                uri = new URI(uriJson.asString());
            }
            catch (URISyntaxException e2) {
                throw new HtsgetMalformedResponseException("Could not parse URI in Htsget data block: " + uriJson.asString(), e2);
            }
            Json dataClassJson = blockJson.at("class");
            HtsgetClass dataClass = dataClassJson == null ? null : HtsgetClass.valueOf(dataClassJson.asString().toLowerCase());
            Json headersJson = blockJson.at("headers");
            Map<String, String> headers = headersJson == null ? null : headersJson.asJsonMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Json)e.getValue()).asString()));
            return new Block(uri, headers, dataClass);
        }
    }
}

