#version 330 core
// You may try to use higher versions of GLSL if you not use GL330 compatibility 
// AB version.
// --------------------------------------------------------------------
// DO NOT CHANGE this part of code: Uniforms below must be define
// those variables are always provided by AwesomeBump. However one may
// use them in your custom shader. 
// --------------------------------------------------------------------
// Uniform textures
uniform sampler2D texDiffuse;
uniform sampler2D texNormal;
uniform sampler2D texSpecular;
uniform sampler2D texHeight;
uniform sampler2D texSSAO;
uniform sampler2D texRoughness;
uniform sampler2D texMetallic;
uniform sampler2D texMaterial;

uniform samplerCube texPrefilteredEnvMap;  // prefilltered diffuse cube map
uniform samplerCube texSourceEnvMap;       // full cube map
uniform int num_mipmaps; 	       	   // number of mipmaps of texSourceEnvMap

// Camera/light/matrices
uniform vec3 cameraPos; 	// View Camera Position
uniform vec3 lightDirection; 	// Light direction always points to the center of the center of system (0,0,0) normalized. Mouse cause rotation of this light
uniform vec4 lightPos;		// Another light position. Here: z-th component ie equal z=5.0. Mouse changes only the x,y components. (Flashlight behaviour).

uniform mat4 ModelMatrix;	// Pure Translation/Rotation of the oryginal components of the rendered Mesh
uniform mat4 ModelViewMatrix;	// ViewMatrix * ModelMatrix; Here ViewMatrix is generated by Camera with lookAt method.
uniform mat3 NormalMatrix;	// NormalMatrix obtained from ModelViewMatrix.


// Uniform controlable from GUI, those parameters are used in AwesomeBump.frag shader
// you may use them to customize your rendering 
uniform bool gui_bSpecular;	// enable specular texture
uniform bool gui_bOcclusion;	// enable Occlusion texture
uniform bool gui_bHeight;	// enable Height texture
uniform bool gui_bDiffuse;	// enable Diffuse texture
uniform bool gui_bNormal;	// enable Normal texture
uniform bool gui_bRoughness;	// enable Roughness texture
uniform bool gui_bMetallic;	// enable Metallic texture
uniform bool gui_bUseSimplePBR; 	   // enable simplified version of PBR shading
uniform bool gui_bMaterialsPreviewEnabled; // enable Material texture preview
uniform bool gui_bShowTriangleEdges;	   // show mesh triangles

// Lightning related variables
uniform float gui_LightPower;		// Light power variable
uniform float gui_LightRadius;		// Light radius variable
uniform float gui_SpecularIntensity;	// Intensity of Specular effect
uniform float gui_DiffuseIntensity;	// Intensity of Diffuse effect
uniform int gui_noPBRRays;		// Number of rays taken in high quality PRB calulations

// UV related variables
uniform  float gui_depthScale;		// UV relief depth scale 

// Enums accesible from GUI
uniform int gui_shading_type;  // 0 - relief mapping , 1 - parallax normal mapping , 2 - tessellation
uniform int gui_shading_model; // 0 - PBR , 1 - Bump mapping


// --------------------------------------------------------------------
// DO NOT CHANGE this part of code: Necessary outcome from fragment
// shader. Four buffors are used for further post-processing. 
// --------------------------------------------------------------------

layout(location = 0) out vec4 FragColor;	// Final Color of pixel
layout(location = 1) out vec4 FragNormal;	// Frag Normal - Not used 
layout(location = 2) out vec4 FragGlowColor;	// Glow Color - initial color taken form Glow effect caluclation
layout(location = 3) out vec4 FragPosition;	// Frag Eye space position - need to be vec4(ESVertexPosition,1) used for DOF caclulation


// --------------------------------------------------------------------
// DO NOT CHANGE this part of code: Incoming attributes and small 
// explanation how they were computed in geometry shader - see comments
// --------------------------------------------------------------------

// Eye space attributed computed in geometry shader
in vec3 ESVertexPosition; 	// Vertex position defined as: ModelViewMatrix * vPosition, where vPosition i basically oryginal position in Obj. 
in vec3 ESVertexNormal;		// Vertex normal    = NormalMatrix * vNormal
in vec3 ESVertexTangent;	// Vertex tangent   = NormalMatrix * vTangent
in vec3 ESVertexBitangent;	// Vertex bitangent = NormalMatrix * vBitangent
in vec3 ESHalfVector;		// ES Half vector is computed: normalize((0,0,5)+ESVertexPosition.xyz)


// Tangent space variables used for Relief mapping are following:

// Let us define two vectors: eyeLightVectors and eyeViewVectors 
//	vec3 eyeLightVectors[2];
//	eyeLightVectors[0] = normalize(-ESVertexPosition.xyz);
//	eyeLightVectors[1] = normalize(lightPos.xyz-ESVertexPosition.xyz);
//	vec3 eyeViewVectors[2];
//	eyeViewVectors[0] = -normalize(ESVertexPosition.xyz);
//	eyeViewVectors[1] = -normalize(ESVertexPosition.xyz);

// Additionally ESTBN matrix is computed: ESTBN = transpose(mat3(ESVertexTangent,ESVertexBitangent,ESVertexNormal));

const int no_lights = 2;
in vec3 TSLightPosition[no_lights]; // TSLightPosition[i] =  ESTBN * eyeLightDir[i];
in vec3 TSViewDirection[no_lights]; // TSViewDirection[i] =  ESTBN * eyeViewVectors[i];
in vec3 TSHalfVector;	// then tangent space half vector is calculated as TSHalfVector = ESTBN * ESHalfVector

in vec3 texcoord; // Frag UV coordinate

// World space attributes evaluated in geometry shader
in vec3 WSTangent; 	// Tangent   vector calculated as: mat3(ModelMatrix)*vTangent 
in vec3 WSBitangent;	// Bitangent vector calculated as: mat3(ModelMatrix)*vBitangent 
in vec3 WSNormal;	// Normal    vector calculated as: mat3(ModelMatrix)*vNormal 
in vec3 WSPosition;	// Position calculate from: (ModelMatrix * vec4( newPos[i],1)).xyz;
in mat3 TBN; 		// Wordl space TBN matrix calculated from transpose(mat3(WSTangent,WSBitangent,WSNormal));


// --------------------------------------------------------------------
// HERE you can put defined by you new uniform variables.
// 
// Supported types:
//	- float
//	- int
// The number of user defined uniform variables is limited to about 20 for now.
//				***
// EXAMPLE usage of user define uniform variable:
uniform float example_float; // value=0.0; min = -10.0 ; max= 10.0 ; step = 0.1 ; name = "Example float" ; description = "This parameter does nothing"
// NOTE that each uniform has to be followed by special one line comment: filled with following parameters
// 	min 	(must be define)- minimum allowed value
//	max 	(must be define)- maximum value
//	value 	(must be define)- default value which will be loaded each time you start AB
//	step 	(must be define)- singleStep 
//	name 	(optional)	- human readable name visible in GUI
//	description (optional)	- explanation for other users what this parameter does
// --------------------------------------------------------------------

uniform float glow_Level; // value = 0.4 ; min = 0.0 ; max = 1.0 ; step = 0.01 ; name = "Glow level" ; description = "Changes the cutoff color of the glow input image"
uniform float specular_Strength; // value = 3.0; min=0.0;max=100;step =0.1 ; name = "Specular strength" ; description = "Change the specular reflection influence"
// ---------------------------------------------------------------------
// TEMPLATE FRAGMENT SHADER - written by Krzysztof Kolasinski @2015
// Only standard relief mapping is done here
// ---------------------------------------------------------------------

float depth = 0.04*gui_depthScale;

// Global variables
vec3 Kd = vec3(gui_DiffuseIntensity);
vec3 Ks = vec3(gui_SpecularIntensity*0.5);
vec3 Ka = vec3(0.0);
float alpha =  1.0 / (gui_LightRadius*0.1 + 0.01);

vec3 LightSource_diffuse  = vec3(1.0);
vec3 LightSource_ambient  = vec3(1.0);
vec3 LightSource_specular = vec3(1.0);
vec3 normalizedLightDirection = normalize(lightDirection);
// global variables
vec3  fvESVertexNormal;
vec4  fvBaseColor;
vec4  fvSpecularColor;
vec4  fvSSAOColor;
float fvGlossiness;
vec4  fvRoughness;
vec4  fvMetallic;


// Implemenetation of typical bump-mapping glsl shader based on phong model
vec4 bump_mapping(int lightIndeks,vec2 texcoord){

    vec3  fvTSLightPosition  = normalize( TSLightPosition[lightIndeks] );
    float fNDotL             = max(dot( fvESVertexNormal, fvTSLightPosition ),0.0);
    vec3  fvReflection       = normalize( ( ( 2.0 * fvESVertexNormal ) * fNDotL ) - fvTSLightPosition );
    vec3  fvTSViewDirection  = normalize( TSViewDirection[lightIndeks] );
    float fRDotV             = max( 0.0, dot( fvReflection, fvTSViewDirection ) );

    vec4  fvTotalAmbient   = vec4(Ka * LightSource_ambient,1) * fvBaseColor;
    vec4  fvTotalDiffuse   = gui_LightPower * vec4(Kd * LightSource_diffuse,1) * fNDotL * fvBaseColor;
    vec3  lightDirection   = normalize( TSLightPosition[lightIndeks] );
    vec4  fvTotalSpecular  = gui_LightPower * vec4(Ks * LightSource_specular,1) * ( pow( fRDotV, alpha*fvGlossiness ) ) * fvSpecularColor * specular_Strength;

    if(!gui_bSpecular) fvTotalSpecular = vec4(0);

    return ( fvTotalDiffuse*fvSSAOColor + fvTotalSpecular);
}


// This function is based on shader from kiirala github repo: url:  https://github.com/kiirala/reliefmap
// Calculation of frag depth based on height map and ES vectors
vec2 relief_mapping() {
        if (gui_bHeight){
        vec3 N          = normalize(ESVertexNormal);
        vec3 eview      = normalize(ESVertexPosition);
        vec3 etangent   = normalize(ESVertexTangent);
        vec3 ebitangent = normalize(ESVertexBitangent);

        vec3 tview      = normalize(vec3(dot(eview, etangent), dot(eview, ebitangent), dot(eview, -N)));
        vec2 ds         = tview.xy * depth / tview.z;
        vec2 dp         = texcoord.xy;

        const int linear_steps = 15;
        const int binary_steps = 15;
        float depth_step = 1.0 / linear_steps;
        float size = depth_step;
        float depth = 1.0;
        float best_depth = 1.0;
        for (int i = 0 ; i < linear_steps - 1 ; ++i) {
                depth -= size;
                vec4 t = texture(texHeight, dp + ds * depth);
                if (depth >= 1.0 - t.r)
                        best_depth = depth;
        }
        depth = best_depth - size;
        for (int i = 0 ; i < binary_steps ; ++i) {
                size *= 0.5;
                vec4 t = texture(texHeight, dp + ds * depth);
                if (depth >= 1.0 - t.r) {
                        best_depth = depth;
                        depth -= 2 * size;
                }
                depth += size;
        }

        return dp + best_depth * ds;
        }else return texcoord.st;
}

// ---------------------------------------------------------------------
// Template shader - main function
// returns:
// 	FragColor     - Final color of pixel
//	FragGlowColor - Glow effect
//	FragPosition  - DOF post processing
// ---------------------------------------------------------------------

void main( void )
{

    // This
    if(gui_bShowTriangleEdges){
        if(gui_bMaterialsPreviewEnabled) FragColor = texture(texDiffuse, texcoord.st);
        else FragColor     = vec4(0);
        FragColor.a   = 1;
        FragNormal    = vec4(0);
        FragGlowColor = vec4(0);
        FragPosition  = vec4(10);
        return;
    }

    if(gui_bMaterialsPreviewEnabled){
        FragColor     = texture(texMaterial, texcoord.st);
        FragNormal    = vec4(0);
        FragGlowColor = vec4(0);
        FragPosition  = vec4(0);
        return;
    }

    // calculate uv coords based on selected algorithm
    vec2 texcoords = relief_mapping();
    
   
    // setting up global variables
    fvESVertexNormal   = normalize( ( texture( texNormal, texcoords.xy ).xyz * 2.0 ) - 1.0 );
    if(!gui_bNormal)     fvESVertexNormal = vec3(0,0,1);

    fvBaseColor        = texture( texDiffuse, texcoords.xy );
    fvSpecularColor    = texture( texSpecular, texcoords.xy );
    fvSSAOColor        = texture( texSSAO, texcoords.xy );
    fvRoughness        = texture( texRoughness, texcoords.xy );
    fvMetallic         = texture( texMetallic, texcoords.xy );
    fvGlossiness       = clamp(fvRoughness.r,0.0,1.0)*100+1.0;

    if(!gui_bRoughness) fvGlossiness   = 1.0;
    if(!gui_bDiffuse)  fvBaseColor     = vec4(0.8); // some gray color
    if(!gui_bOcclusion)fvSSAOColor     = vec4(1.0);
    if(!gui_bSpecular) fvSpecularColor = vec4(0);

    
    vec3 surfaceNormal= normalize(transpose(TBN)*fvESVertexNormal); // approximated normal in world space 
    vec3 irradiance   = texture(texPrefilteredEnvMap, normalize(surfaceNormal)).rgb;
    fvBaseColor.rgb  *= irradiance ;
    
    vec4 bumpMapShadingColor = (bump_mapping(0,texcoords)+bump_mapping(1,texcoords))/2;
    FragColor  = bumpMapShadingColor;
    
    
    // -------------------------------------------------------------
    // Output for glow effect
    // -------------------------------------------------------------
    
    float level      = dot(FragColor.rgb,FragColor.rgb)/3;
    FragGlowColor    = vec4(0);
    if(level > glow_Level )FragGlowColor = FragColor;
        
    // -------------------------------------------------------------
    // Not used:
    // -------------------------------------------------------------
    FragNormal    = vec4(0);
        
    // -------------------------------------------------------------
    // This must be like this:
    // -------------------------------------------------------------
    FragPosition  = vec4(ESVertexPosition,1);
   
}
